/*
 Navicat Premium Data Transfer

 Source Server         : Local Instance
 Source Server Type    : MySQL
 Source Server Version : 50617 (5.6.17)
 Source Host           : localhost:3306
 Source Schema         : e_circle_dev

 Target Server Type    : MySQL
 Target Server Version : 50617 (5.6.17)
 File Encoding         : 65001

 Date: 15/09/2025 07:41:03
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for attempt
-- ----------------------------
DROP TABLE IF EXISTS `attempt`;
CREATE TABLE `attempt`  (
  `attempt_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `marks` double NOT NULL,
  `time_taken` bigint(20) NOT NULL,
  `student_student_id` bigint(20) NULL DEFAULT NULL,
  `test_test_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`attempt_id`) USING BTREE,
  INDEX `FKpnmnt3dosoh8wlt5rujrsah2c`(`student_student_id`) USING BTREE,
  INDEX `FKguq5n79qc3d1hw6lj8mpbifqs`(`test_test_id`) USING BTREE,
  CONSTRAINT `FKguq5n79qc3d1hw6lj8mpbifqs` FOREIGN KEY (`test_test_id`) REFERENCES `test` (`test_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FKpnmnt3dosoh8wlt5rujrsah2c` FOREIGN KEY (`student_student_id`) REFERENCES `student` (`student_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of attempt
-- ----------------------------
INSERT INTO `attempt` VALUES (2, 0, '2025-08-01 23:49:50.693000', 0, '2025-08-01 23:49:51.024000', 1, 25, 161000, 1, 1);
INSERT INTO `attempt` VALUES (3, 0, '2025-08-03 14:13:51.979000', 0, '2025-08-03 14:13:52.077000', 1, 15, 37000, 15, 3);

-- ----------------------------
-- Table structure for batch
-- ----------------------------
DROP TABLE IF EXISTS `batch`;
CREATE TABLE `batch`  (
  `batch_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `availability` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `closing_date` date NULL DEFAULT NULL,
  `code` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `lecture_day_type` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `starting_date` date NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `course_course_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`batch_id`) USING BTREE,
  INDEX `FKb3bolgxwdqpnasn9691r4of7b`(`course_course_id`) USING BTREE,
  CONSTRAINT `FKb3bolgxwdqpnasn9691r4of7b` FOREIGN KEY (`course_course_id`) REFERENCES `course` (`course_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of batch
-- ----------------------------

-- ----------------------------
-- Table structure for batch_student
-- ----------------------------
DROP TABLE IF EXISTS `batch_student`;
CREATE TABLE `batch_student`  (
  `batch_student_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `joined_date` date NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `batch_batch_id` bigint(20) NULL DEFAULT NULL,
  `student_student_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`batch_student_id`) USING BTREE,
  INDEX `FKg2tm9ylp5x2m7i72waa6js583`(`batch_batch_id`) USING BTREE,
  INDEX `FK2f63p22oe3eg86lk27u254ri6`(`student_student_id`) USING BTREE,
  CONSTRAINT `FK2f63p22oe3eg86lk27u254ri6` FOREIGN KEY (`student_student_id`) REFERENCES `student` (`student_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FKg2tm9ylp5x2m7i72waa6js583` FOREIGN KEY (`batch_batch_id`) REFERENCES `batch` (`batch_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of batch_student
-- ----------------------------

-- ----------------------------
-- Table structure for course
-- ----------------------------
DROP TABLE IF EXISTS `course`;
CREATE TABLE `course`  (
  `course_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `category` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `description` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `duration_month` int(11) NOT NULL,
  `duration_year` int(11) NOT NULL,
  `module_available` bit(1) NOT NULL,
  `no_of_semesters` int(11) NOT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `coordinator_lecturer_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`course_id`) USING BTREE,
  INDEX `FKi0d2gy8ubj9vwqsspiwsugi0i`(`coordinator_lecturer_id`) USING BTREE,
  CONSTRAINT `FKi0d2gy8ubj9vwqsspiwsugi0i` FOREIGN KEY (`coordinator_lecturer_id`) REFERENCES `lecturer` (`lecturer_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of course
-- ----------------------------
INSERT INTO `course` VALUES (1, 0, '2025-07-31 23:26:45.678000', 0, '2025-07-31 23:26:45.678000', 0, 'DEG', 'Bachelor of IT', 0, 3, b'1', 6, 'A', 1);

-- ----------------------------
-- Table structure for course_module
-- ----------------------------
DROP TABLE IF EXISTS `course_module`;
CREATE TABLE `course_module`  (
  `course_module_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `approach` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `code` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `credit_count` int(11) NOT NULL,
  `description` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `evaluation` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `name` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `lecturer_lecturer_id` bigint(20) NULL DEFAULT NULL,
  `semester_semester_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`course_module_id`) USING BTREE,
  INDEX `FKsjb1jw28on5ky1gbyqkilrq3e`(`lecturer_lecturer_id`) USING BTREE,
  INDEX `FKjw230c0xm6gjichrs3rg4sk5k`(`semester_semester_id`) USING BTREE,
  CONSTRAINT `FKjw230c0xm6gjichrs3rg4sk5k` FOREIGN KEY (`semester_semester_id`) REFERENCES `semester` (`semester_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FKsjb1jw28on5ky1gbyqkilrq3e` FOREIGN KEY (`lecturer_lecturer_id`) REFERENCES `lecturer` (`lecturer_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of course_module
-- ----------------------------
INSERT INTO `course_module` VALUES (1, 0, '2025-08-01 10:25:34.435000', 0, '2025-08-01 10:25:34.435000', 0, 'T', 'IT1001', 3, NULL, 'E', 'Information Systems', 'A', 1, 1);
INSERT INTO `course_module` VALUES (2, 0, '2025-08-03 09:56:19.895000', 0, '2025-08-03 14:18:33.812000', 1, 'T', 'CS', 3, NULL, 'E', 'Computer Systems', 'A', 2, 1);
INSERT INTO `course_module` VALUES (3, 0, '2025-08-03 11:47:14.990000', 0, '2025-08-03 11:47:14.990000', 0, 'T', 'IT4500', 30, NULL, 'B', 'Introductory Mathematics', 'A', 2, 1);
INSERT INTO `course_module` VALUES (4, 0, '2025-08-03 11:48:08.930000', 0, '2025-08-03 11:49:07.149000', 1, 'T', 'IT4600', 24, NULL, 'E', 'Information Systems', 'D', 1, 1);
INSERT INTO `course_module` VALUES (5, 0, '2025-08-03 11:48:51.384000', 0, '2025-08-03 11:48:51.384000', 0, 'T', 'IT4700', 30, NULL, 'E', 'Introduction to Programming', 'A', 1, 1);
INSERT INTO `course_module` VALUES (6, 0, '2025-08-03 11:50:11.789000', 0, '2025-08-03 11:50:11.789000', 0, 'B', 'IT4800', 25, NULL, 'B', 'Free and Open Source Software for Personal Computing', 'A', 2, 1);

-- ----------------------------
-- Table structure for feedback
-- ----------------------------
DROP TABLE IF EXISTS `feedback`;
CREATE TABLE `feedback`  (
  `feedback_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `rating` int(11) NOT NULL,
  `remark` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `student_attendance_student_attendance_id` bigint(20) NULL DEFAULT NULL,
  `anonymous` bit(1) NOT NULL,
  PRIMARY KEY (`feedback_id`) USING BTREE,
  INDEX `FK9hhl4kgbmg8p6kp7hstm0ctay`(`student_attendance_student_attendance_id`) USING BTREE,
  CONSTRAINT `FK9hhl4kgbmg8p6kp7hstm0ctay` FOREIGN KEY (`student_attendance_student_attendance_id`) REFERENCES `student_attendance` (`student_attendance_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 6 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of feedback
-- ----------------------------
INSERT INTO `feedback` VALUES (1, 0, '2025-07-31 11:22:36.646000', 0, '2025-07-31 11:22:36.646000', 0, 5, NULL, 'SUB', 6, b'0');
INSERT INTO `feedback` VALUES (2, 0, '2025-08-03 01:34:05.698000', 0, '2025-08-03 01:34:05.698000', 0, 3, NULL, 'SUB', 1, b'0');
INSERT INTO `feedback` VALUES (3, 0, '2025-08-03 01:59:04.705000', 0, '2025-08-03 01:59:04.705000', 0, 2, NULL, 'SUB', 2, b'0');
INSERT INTO `feedback` VALUES (4, 0, '2025-08-03 14:02:38.842000', 0, '2025-08-03 14:08:59.903000', 1, 5, NULL, 'SUB', 3, b'1');
INSERT INTO `feedback` VALUES (5, 0, '2025-08-03 14:04:53.317000', 0, '2025-08-03 14:04:53.317000', 0, 0, NULL, 'PEN', 4, b'0');

-- ----------------------------
-- Table structure for geo_area
-- ----------------------------
DROP TABLE IF EXISTS `geo_area`;
CREATE TABLE `geo_area`  (
  `geo_area_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `code` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `description` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `geo_type` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `geo_parent_geo_area_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`geo_area_id`) USING BTREE,
  INDEX `FKcvb1ypnxtfiihof2nav7dppth`(`geo_parent_geo_area_id`) USING BTREE,
  CONSTRAINT `FKcvb1ypnxtfiihof2nav7dppth` FOREIGN KEY (`geo_parent_geo_area_id`) REFERENCES `geo_area` (`geo_area_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1841 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of geo_area
-- ----------------------------
INSERT INTO `geo_area` VALUES (1, 0, NULL, 0, NULL, 0, NULL, 'Sri Lanka', 'CO', 'I', NULL);
INSERT INTO `geo_area` VALUES (2, 0, NULL, 2, '2023-05-22 10:12:43.000000', 3, NULL, 'Western', 'PR', 'I', 1);
INSERT INTO `geo_area` VALUES (3, 0, NULL, 0, NULL, 0, NULL, 'Central', 'PR', 'I', 1);
INSERT INTO `geo_area` VALUES (4, 0, NULL, 0, NULL, 0, NULL, 'Eastern', 'PR', 'I', 1);
INSERT INTO `geo_area` VALUES (5, 0, NULL, 0, NULL, 0, NULL, 'Northern', 'PR', 'I', 1);
INSERT INTO `geo_area` VALUES (6, 0, NULL, 0, NULL, 0, NULL, 'Southern', 'PR', 'I', 1);
INSERT INTO `geo_area` VALUES (7, 0, NULL, 0, NULL, 0, NULL, 'North Western', 'PR', 'I', 1);
INSERT INTO `geo_area` VALUES (8, 0, NULL, 0, NULL, 0, NULL, 'North Central', 'PR', 'I', 1);
INSERT INTO `geo_area` VALUES (9, 0, NULL, 0, NULL, 0, NULL, 'Uva', 'PR', 'I', 1);
INSERT INTO `geo_area` VALUES (10, 0, NULL, 0, NULL, 0, NULL, 'Sabaragamuwa', 'PR', 'I', 1);
INSERT INTO `geo_area` VALUES (11, 0, NULL, 2, '2023-05-22 04:40:44.000000', 1, NULL, 'Colombo', 'DI', 'I', 2);
INSERT INTO `geo_area` VALUES (12, 0, NULL, 0, NULL, 0, NULL, 'Gampaha', 'DI', 'I', 2);
INSERT INTO `geo_area` VALUES (13, 0, NULL, 0, NULL, 0, NULL, 'Kalutara', 'DI', 'I', 2);
INSERT INTO `geo_area` VALUES (14, 0, NULL, 0, NULL, 0, NULL, 'Kandy', 'DI', 'I', 3);
INSERT INTO `geo_area` VALUES (15, 0, NULL, 0, NULL, 0, NULL, 'Matale', 'DI', 'I', 3);
INSERT INTO `geo_area` VALUES (16, 0, NULL, 0, NULL, 0, NULL, 'Nuwara Eliya', 'DI', 'I', 3);
INSERT INTO `geo_area` VALUES (17, 0, NULL, 0, NULL, 0, NULL, 'Ampara', 'DI', 'I', 4);
INSERT INTO `geo_area` VALUES (18, 0, NULL, 0, NULL, 0, NULL, 'Batticaloa', 'DI', 'I', 4);
INSERT INTO `geo_area` VALUES (19, 0, NULL, 0, NULL, 0, NULL, 'Trincomalee', 'DI', 'I', 4);
INSERT INTO `geo_area` VALUES (20, 0, NULL, 0, NULL, 0, NULL, 'Jaffna', 'DI', 'I', 5);
INSERT INTO `geo_area` VALUES (21, 0, NULL, 0, NULL, 0, NULL, 'Kilinochchi', 'DI', 'I', 5);
INSERT INTO `geo_area` VALUES (22, 0, NULL, 0, NULL, 0, NULL, 'Mannar', 'DI', 'I', 5);
INSERT INTO `geo_area` VALUES (23, 0, NULL, 0, NULL, 0, NULL, 'Mullaitivu', 'DI', 'I', 5);
INSERT INTO `geo_area` VALUES (24, 0, NULL, 0, NULL, 0, NULL, 'Vavuniya', 'DI', 'I', 5);
INSERT INTO `geo_area` VALUES (25, 0, NULL, 0, NULL, 0, NULL, 'Galle', 'DI', 'I', 6);
INSERT INTO `geo_area` VALUES (26, 0, NULL, 0, NULL, 0, NULL, 'Matara', 'DI', 'I', 6);
INSERT INTO `geo_area` VALUES (27, 0, NULL, 0, NULL, 0, NULL, 'Hambantota', 'DI', 'I', 6);
INSERT INTO `geo_area` VALUES (28, 0, NULL, 0, NULL, 0, NULL, 'Kurunegala', 'DI', 'I', 7);
INSERT INTO `geo_area` VALUES (29, 0, NULL, 0, NULL, 0, NULL, 'Puttalam', 'DI', 'I', 7);
INSERT INTO `geo_area` VALUES (30, 0, NULL, 0, NULL, 0, NULL, 'Anuradhapura', 'DI', 'I', 8);
INSERT INTO `geo_area` VALUES (31, 0, NULL, 0, NULL, 0, NULL, 'Polonnaruwa', 'DI', 'I', 8);
INSERT INTO `geo_area` VALUES (32, 0, NULL, 0, NULL, 0, NULL, 'Badulla', 'DI', 'I', 9);
INSERT INTO `geo_area` VALUES (33, 0, NULL, 0, NULL, 0, NULL, 'Monaragala', 'DI', 'I', 9);
INSERT INTO `geo_area` VALUES (34, 0, NULL, 0, NULL, 0, NULL, 'Kegalle', 'DI', 'I', 10);
INSERT INTO `geo_area` VALUES (35, 0, NULL, 0, NULL, 0, NULL, 'Ratnapura', 'DI', 'I', 10);
INSERT INTO `geo_area` VALUES (36, 0, NULL, 0, NULL, 0, NULL, 'Colombo 01', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (37, 0, NULL, 0, NULL, 0, NULL, 'Colombo 02', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (38, 0, NULL, 0, NULL, 0, NULL, 'Colombo 03', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (39, 0, NULL, 0, NULL, 0, NULL, 'Colombo 04', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (40, 0, NULL, 0, NULL, 0, NULL, 'Colombo 05', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (41, 0, NULL, 0, NULL, 0, NULL, 'Colombo 06', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (42, 0, NULL, 0, NULL, 0, NULL, 'Colombo 07', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (43, 0, NULL, 0, NULL, 0, NULL, 'Colombo 08', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (44, 0, NULL, 0, NULL, 0, NULL, 'Colombo 09', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (45, 0, NULL, 0, NULL, 0, NULL, 'Colombo 10', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (46, 0, NULL, 0, NULL, 0, NULL, 'Colombo 11', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (47, 0, NULL, 0, NULL, 0, NULL, 'Colombo 12', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (48, 0, NULL, 0, NULL, 0, NULL, 'Colombo 13', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (49, 0, NULL, 0, NULL, 0, NULL, 'Colombo 14', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (50, 0, NULL, 0, NULL, 0, NULL, 'Colombo 15', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (51, 0, NULL, 0, NULL, 0, NULL, 'Akarawita', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (52, 0, NULL, 0, NULL, 0, NULL, 'Angamuwa', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (53, 0, NULL, 0, NULL, 0, NULL, 'Athurugiriya', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (54, 0, NULL, 0, NULL, 0, NULL, 'Avissawella', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (55, 0, NULL, 0, NULL, 0, NULL, 'Batawala', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (56, 0, NULL, 0, NULL, 0, NULL, 'Battaramulla', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (57, 0, NULL, 0, NULL, 0, NULL, 'Batugampola', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (58, 0, NULL, 0, NULL, 0, NULL, 'Bope', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (59, 0, NULL, 0, NULL, 0, NULL, 'Boralesgamuwa', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (60, 0, NULL, 0, NULL, 0, NULL, 'Borella', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (61, 0, NULL, 0, NULL, 0, NULL, 'Dedigamuwa', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (62, 0, NULL, 0, NULL, 0, NULL, 'Dehiwala', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (63, 0, NULL, 0, NULL, 0, NULL, 'Deltara', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (64, 0, NULL, 0, NULL, 0, NULL, 'Habarakada', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (65, 0, NULL, 0, NULL, 0, NULL, 'Handapangoda', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (66, 0, NULL, 0, NULL, 0, NULL, 'Hanwella', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (67, 0, NULL, 0, NULL, 0, NULL, 'Hewainna', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (68, 0, NULL, 0, NULL, 0, NULL, 'Hiripitya', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (69, 0, NULL, 0, NULL, 0, NULL, 'Hokandara', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (70, 0, NULL, 0, NULL, 0, NULL, 'Homagama', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (71, 0, NULL, 0, NULL, 0, NULL, 'Horagala', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (72, 0, NULL, 0, NULL, 0, NULL, 'Kaduwela', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (73, 0, NULL, 0, NULL, 0, NULL, 'Kahawala', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (74, 0, NULL, 0, NULL, 0, NULL, 'Kalatuwawa', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (75, 0, NULL, 0, NULL, 0, NULL, 'Kiriwattuduwa', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (76, 0, NULL, 0, NULL, 0, NULL, 'Kolonnawa', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (77, 0, NULL, 0, NULL, 0, NULL, 'Kosgama', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (78, 0, NULL, 0, NULL, 0, NULL, 'Madapatha', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (79, 0, NULL, 0, NULL, 0, NULL, 'Maharagama', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (80, 0, NULL, 0, NULL, 0, NULL, 'Malabe', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (81, 0, NULL, 0, NULL, 0, NULL, 'Meegoda', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (82, 0, NULL, 0, NULL, 0, NULL, 'Moratuwa', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (83, 0, NULL, 0, NULL, 0, NULL, 'Morontuduwa', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (84, 0, NULL, 0, NULL, 0, NULL, 'Mullegama', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (85, 0, NULL, 0, NULL, 0, NULL, 'Mulleriyawa New Town', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (86, 0, NULL, 0, NULL, 0, NULL, 'Napawela', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (87, 0, NULL, 0, NULL, 0, NULL, 'Nugegoda', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (88, 0, NULL, 0, NULL, 0, NULL, 'Pitipana Homagama', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (89, 0, NULL, 0, NULL, 0, NULL, 'Rajagiriya', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (90, 0, NULL, 0, NULL, 0, NULL, 'Padukka', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (91, 0, NULL, 0, NULL, 0, NULL, 'Pannipitiya', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (92, 0, NULL, 0, NULL, 0, NULL, 'Piliyandala', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (93, 0, NULL, 0, NULL, 0, NULL, 'Pitipana Homagama', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (94, 0, NULL, 0, NULL, 0, NULL, 'Polgasowita', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (95, 0, NULL, 0, NULL, 0, NULL, 'Puwakpitiya', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (96, 0, NULL, 0, NULL, 0, NULL, 'Ranala', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (97, 0, NULL, 0, NULL, 0, NULL, 'Ratmalana', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (98, 0, NULL, 0, NULL, 0, NULL, 'Siddamulla', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (99, 0, NULL, 0, NULL, 0, NULL, 'Slave Island', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (100, 0, NULL, 0, NULL, 0, NULL, 'Sri Jayawardenapura', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (101, 0, NULL, 0, NULL, 0, NULL, 'Talawatugoda', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (102, 0, NULL, 0, NULL, 0, NULL, 'Tummodara', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (103, 0, NULL, 0, NULL, 0, NULL, 'Waga', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (104, 0, NULL, 0, NULL, 0, NULL, 'Watareka', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (105, 0, NULL, 2, '2023-05-22 04:44:22.000000', 5, NULL, 'Akaragama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (106, 0, NULL, 0, NULL, 0, NULL, 'Alawala', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (107, 0, NULL, 0, NULL, 0, NULL, 'Ambagaspitiya', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (108, 0, NULL, 0, NULL, 0, NULL, 'Ambepussa', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (109, 0, NULL, 0, NULL, 0, NULL, 'Andiambalama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (110, 0, NULL, 0, NULL, 0, NULL, 'Attanagalla', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (111, 0, NULL, 0, NULL, 0, NULL, 'Badalgama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (112, 0, NULL, 0, NULL, 0, NULL, 'Banduragoda', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (113, 0, NULL, 0, NULL, 0, NULL, 'Batuwatta', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (114, 0, NULL, 0, NULL, 0, NULL, 'Bemmulla', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (115, 0, NULL, 0, NULL, 0, NULL, 'Biyagama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (116, 0, NULL, 0, NULL, 0, NULL, 'Biyagama IPZ', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (117, 0, NULL, 0, NULL, 0, NULL, 'Bokalagama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (118, 0, NULL, 0, NULL, 0, NULL, 'Bollete', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (119, 0, NULL, 0, NULL, 0, NULL, 'Bopagama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (120, 0, NULL, 0, NULL, 0, NULL, 'Buthpitiya', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (121, 0, NULL, 0, NULL, 0, NULL, 'Dagonna', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (122, 0, NULL, 0, NULL, 0, NULL, 'Danowita', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (123, 0, NULL, 0, NULL, 0, NULL, 'Debahera', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (124, 0, NULL, 0, NULL, 0, NULL, 'Dekatana', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (125, 0, NULL, 0, NULL, 0, NULL, 'Delgoda', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (126, 0, NULL, 0, NULL, 0, NULL, 'Delwagura', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (127, 0, NULL, 0, NULL, 0, NULL, 'Demalagama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (128, 0, NULL, 0, NULL, 0, NULL, 'Demanhandiya', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (129, 0, NULL, 0, NULL, 0, NULL, 'Dewalapola', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (130, 0, NULL, 0, NULL, 0, NULL, 'Divulapitiya', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (131, 0, NULL, 0, NULL, 0, NULL, 'Divuldeniya', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (132, 0, NULL, 0, NULL, 0, NULL, 'Dompe', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (133, 0, NULL, 0, NULL, 0, NULL, 'Dunagaha', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (134, 0, NULL, 0, NULL, 0, NULL, 'Ekala', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (135, 0, NULL, 0, NULL, 0, NULL, 'Ellakkala', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (136, 0, NULL, 0, NULL, 0, NULL, 'Essella', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (137, 0, NULL, 0, NULL, 0, NULL, 'Gampaha', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (138, 0, NULL, 0, NULL, 0, NULL, 'Ganemulla', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (139, 0, NULL, 0, NULL, 0, NULL, 'GonawalaWP', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (140, 0, NULL, 0, NULL, 0, NULL, 'Heiyanthuduwa', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (141, 0, NULL, 0, NULL, 0, NULL, 'Henegama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (142, 0, NULL, 0, NULL, 0, NULL, 'Hinatiyana', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (143, 0, NULL, 0, NULL, 0, NULL, 'Hiswella', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (144, 0, NULL, 0, NULL, 0, NULL, 'Horampella', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (145, 0, NULL, 0, NULL, 0, NULL, 'Hunumulla', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (146, 0, NULL, 0, NULL, 0, NULL, 'Ihala Madampella', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (147, 0, NULL, 0, NULL, 0, NULL, 'Imbulgoda', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (148, 0, NULL, 0, NULL, 0, NULL, 'Ja-Ela	', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (149, 0, NULL, 0, NULL, 0, NULL, 'Kadawatha', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (150, 0, NULL, 0, NULL, 0, NULL, 'Kahatowita', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (151, 0, NULL, 0, NULL, 0, NULL, 'Kalagedihena', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (152, 0, NULL, 0, NULL, 0, NULL, 'Kaleliya', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (153, 0, NULL, 0, NULL, 0, NULL, 'Kaluaggala', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (154, 0, NULL, 0, NULL, 0, NULL, 'Kandana', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (155, 0, NULL, 0, NULL, 0, NULL, 'Kapugoda', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (156, 0, NULL, 0, NULL, 0, NULL, 'Kalugala', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (157, 0, NULL, 0, NULL, 0, NULL, 'Katana', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (158, 0, NULL, 0, NULL, 0, NULL, 'Katunayake', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (159, 0, NULL, 0, NULL, 0, NULL, 'Katunayake Air Force Camp', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (160, 0, NULL, 0, NULL, 0, NULL, 'Katunayake IPZ', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (161, 0, NULL, 0, NULL, 0, NULL, 'Katuwellegama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (162, 0, NULL, 0, NULL, 0, NULL, 'Kelaniya', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (163, 0, NULL, 0, NULL, 0, NULL, 'Kirindiwela', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (164, 0, NULL, 0, NULL, 0, NULL, 'Kitalawalana', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (165, 0, NULL, 0, NULL, 0, NULL, 'Kitulwala', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (166, 0, NULL, 0, NULL, 0, NULL, 'Kochchikade', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (167, 0, NULL, 0, NULL, 0, NULL, 'Kotadeniyawa', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (168, 0, NULL, 0, NULL, 0, NULL, 'Kotugoda', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (169, 0, NULL, 0, NULL, 0, NULL, 'Kumbaloluwa', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (170, 0, NULL, 0, NULL, 0, NULL, 'Loluwagoda', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (171, 0, NULL, 0, NULL, 0, NULL, 'Lunugama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (172, 0, NULL, 0, NULL, 0, NULL, 'Mabodale', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (173, 0, NULL, 0, NULL, 0, NULL, 'Madelgamuwa', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (174, 0, NULL, 0, NULL, 0, NULL, 'Makewita', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (175, 0, NULL, 0, NULL, 0, NULL, 'Makola', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (176, 0, NULL, 0, NULL, 0, NULL, 'Malwana', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (177, 0, NULL, 0, NULL, 0, NULL, 'Mandawala', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (178, 0, NULL, 0, NULL, 0, NULL, 'Marandagahamula', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (179, 0, NULL, 0, NULL, 0, NULL, 'Mellawagedara', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (180, 0, NULL, 0, NULL, 0, NULL, 'Minuwangoda', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (181, 0, NULL, 0, NULL, 0, NULL, 'Mirigama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (182, 0, NULL, 0, NULL, 0, NULL, 'Muddaragama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (183, 0, NULL, 0, NULL, 0, NULL, 'Mudungoda', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (184, 0, NULL, 0, NULL, 0, NULL, 'Naranwala', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (185, 0, NULL, 0, NULL, 0, NULL, 'Nawana', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (186, 0, NULL, 0, NULL, 0, NULL, 'Nedungamuwa', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (187, 0, NULL, 0, NULL, 0, NULL, 'Negombo', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (188, 0, NULL, 0, NULL, 0, NULL, 'Nikahetikanda', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (189, 0, NULL, 0, NULL, 0, NULL, 'Nittambuwa', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (190, 0, NULL, 0, NULL, 0, NULL, 'Niwandama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (191, 0, NULL, 0, NULL, 0, NULL, 'Pallewela', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (192, 0, NULL, 0, NULL, 0, NULL, 'Pamunugama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (193, 0, NULL, 0, NULL, 0, NULL, 'Pamunuwatta', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (194, 0, NULL, 0, NULL, 0, NULL, 'Pasyala', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (195, 0, NULL, 0, NULL, 0, NULL, 'Peliyagoda', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (196, 0, NULL, 0, NULL, 0, NULL, 'Pepiliyawala', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (197, 0, NULL, 0, NULL, 0, NULL, 'Pethiyagoda', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (198, 0, NULL, 0, NULL, 0, NULL, 'Polpithimukulana', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (199, 0, NULL, 0, NULL, 0, NULL, 'Pugoda', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (200, 0, NULL, 0, NULL, 0, NULL, 'Radawadunna', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (201, 0, NULL, 0, NULL, 0, NULL, 'Radawana', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (202, 0, NULL, 0, NULL, 0, NULL, 'Raddolugama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (203, 0, NULL, 0, NULL, 0, NULL, 'Ragama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (204, 0, NULL, 0, NULL, 0, NULL, 'Ruggahawila', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (205, 0, NULL, 0, NULL, 0, NULL, 'Rukmale', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (206, 0, NULL, 0, NULL, 0, NULL, 'Seeduwa', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (207, 0, NULL, 0, NULL, 0, NULL, 'Siyambalape', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (208, 0, NULL, 0, NULL, 0, NULL, 'Talahena', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (209, 0, NULL, 0, NULL, 0, NULL, 'Thimbirigaskatuwa', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (210, 0, NULL, 0, NULL, 0, NULL, 'Tittapattara', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (211, 0, NULL, 0, NULL, 0, NULL, 'Udathuthiripitiya', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (212, 0, NULL, 0, NULL, 0, NULL, 'Udugampola', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (213, 0, NULL, 0, NULL, 0, NULL, 'Uggalboda', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (214, 0, NULL, 0, NULL, 0, NULL, 'Urapola', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (215, 0, NULL, 0, NULL, 0, NULL, 'Uswetakeiyawa', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (216, 0, NULL, 0, NULL, 0, NULL, 'Veyangoda', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (217, 0, NULL, 0, NULL, 0, NULL, 'Walgammulla', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (218, 0, NULL, 0, NULL, 0, NULL, 'Walpita', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (219, 0, NULL, 0, NULL, 0, NULL, 'Walpola (WP)', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (220, 0, NULL, 0, NULL, 0, NULL, 'Wanaluwewa', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (221, 0, NULL, 0, NULL, 0, NULL, 'Wathurugama', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (222, 0, NULL, 0, NULL, 0, NULL, 'Watinapaha', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (223, 0, NULL, 0, NULL, 0, NULL, 'Wattala', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (224, 0, NULL, 0, NULL, 0, NULL, 'Wegowwa', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (225, 0, NULL, 0, NULL, 0, NULL, 'Weweldeniya', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (226, 0, NULL, 0, NULL, 0, NULL, 'Weboda', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (227, 0, NULL, 0, NULL, 0, NULL, 'Yakkala', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (228, 0, NULL, 0, NULL, 0, NULL, 'Yatiyana(WP)', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (229, 0, NULL, 2, '2023-04-25 06:07:37.000000', 2, NULL, 'Agalawatta', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (230, 0, NULL, 0, NULL, 0, NULL, 'Alubomulla', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (231, 0, NULL, 0, NULL, 0, NULL, 'Alutgama', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (232, 0, NULL, 2, '2023-04-25 06:14:29.000000', 2, NULL, 'Anguruwatota', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (233, 0, NULL, 0, NULL, 0, NULL, 'Baduraliya', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (234, 0, NULL, 0, NULL, 0, NULL, 'Bandaragama', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (235, 0, NULL, 0, NULL, 0, NULL, 'Bellana', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (236, 0, NULL, 0, NULL, 0, NULL, 'Beruwala', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (237, 0, NULL, 0, NULL, 0, NULL, 'Bolossagama', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (238, 0, NULL, 0, NULL, 0, NULL, 'Bombuwala', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (239, 0, NULL, 0, NULL, 0, NULL, 'Boralugoda', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (240, 0, NULL, 0, NULL, 0, NULL, 'Bulathsinhala', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (241, 0, NULL, 0, NULL, 0, NULL, 'DanawalaThiniyawala', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (242, 0, NULL, 0, NULL, 0, NULL, 'Delmella', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (243, 0, NULL, 0, NULL, 0, NULL, 'Dharga Town', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (244, 0, NULL, 0, NULL, 0, NULL, 'Diwalakada', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (245, 0, NULL, 0, NULL, 0, NULL, 'Dodangoda', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (246, 0, NULL, 0, NULL, 0, NULL, 'Dombagoda', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (247, 0, NULL, 0, NULL, 0, NULL, 'Galpatha', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (248, 0, NULL, 0, NULL, 0, NULL, 'Gamagoda', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (249, 0, NULL, 0, NULL, 0, NULL, 'Gonapola', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (250, 0, NULL, 0, NULL, 0, NULL, 'Gonapinuwala', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (251, 0, NULL, 0, NULL, 0, NULL, 'Govinna', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (252, 0, NULL, 0, NULL, 0, NULL, 'Gurulubadda', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (253, 0, NULL, 0, NULL, 0, NULL, 'Halkandawila', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (254, 0, NULL, 0, NULL, 0, NULL, 'Haltota', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (255, 0, NULL, 0, NULL, 0, NULL, 'Halwala', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (256, 0, NULL, 0, NULL, 0, NULL, 'Halwatura', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (257, 0, NULL, 0, NULL, 0, NULL, 'Hedigalla Colony', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (258, 0, NULL, 0, NULL, 0, NULL, 'Horana', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (259, 0, NULL, 0, NULL, 0, NULL, 'Ingiriya', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (260, 0, NULL, 0, NULL, 0, NULL, 'Ittapana', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (261, 0, NULL, 0, NULL, 0, NULL, 'Kalawila Kiranthidiya', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (262, 0, NULL, 0, NULL, 0, NULL, 'Kalutara', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (263, 0, NULL, 0, NULL, 0, NULL, 'Kananwila', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (264, 0, NULL, 0, NULL, 0, NULL, 'Kandanagama', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (265, 0, NULL, 0, NULL, 0, NULL, 'Kehelwatta', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (266, 0, NULL, 0, NULL, 0, NULL, 'Kelinkanda', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (267, 0, NULL, 0, NULL, 0, NULL, 'Kitulgoda', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (268, 0, NULL, 0, NULL, 0, NULL, 'Koholana', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (269, 0, NULL, 0, NULL, 0, NULL, 'Kuda Uduwa', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (270, 0, NULL, 0, NULL, 0, NULL, 'lngiriya', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (271, 0, NULL, 0, NULL, 0, NULL, 'Maggona', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (272, 0, NULL, 0, NULL, 0, NULL, 'Mahagama', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (273, 0, NULL, 0, NULL, 0, NULL, 'Mahakalupahana', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (274, 0, NULL, 0, NULL, 0, NULL, 'Matugama', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (275, 0, NULL, 0, NULL, 0, NULL, 'Meegahatenna', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (276, 0, NULL, 0, NULL, 0, NULL, 'Millaniya', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (277, 0, NULL, 0, NULL, 0, NULL, 'Millewa', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (278, 0, NULL, 0, NULL, 0, NULL, 'Morapitiya', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (279, 0, NULL, 0, NULL, 0, NULL, 'Meegama', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (280, 0, NULL, 0, NULL, 0, NULL, 'Neboda', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (281, 0, NULL, 0, NULL, 0, NULL, 'Padagoda', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (282, 0, NULL, 0, NULL, 0, NULL, 'Pahalahewessa', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (283, 0, NULL, 0, NULL, 0, NULL, 'Paiyagala', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (284, 0, NULL, 0, NULL, 0, NULL, 'Panadura', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (285, 0, NULL, 0, NULL, 0, NULL, 'Pannila', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (286, 0, NULL, 0, NULL, 0, NULL, 'Paragastota', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (287, 0, NULL, 0, NULL, 0, NULL, 'Paragoda', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (288, 0, NULL, 0, NULL, 0, NULL, 'Paraigama', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (289, 0, NULL, 0, NULL, 0, NULL, 'Pelanda', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (290, 0, NULL, 0, NULL, 0, NULL, 'Pelawatta', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (291, 0, NULL, 0, NULL, 0, NULL, 'Pokunuwita', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (292, 0, NULL, 0, NULL, 0, NULL, 'Polgampola', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (293, 0, NULL, 0, NULL, 0, NULL, 'Poruwedanda', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (294, 0, NULL, 0, NULL, 0, NULL, 'Remunagoda', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (295, 0, NULL, 0, NULL, 0, NULL, 'Tebuwana', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (296, 0, NULL, 0, NULL, 0, NULL, 'Uduwara', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (297, 0, NULL, 0, NULL, 0, NULL, 'Utumgama', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (298, 0, NULL, 0, NULL, 0, NULL, 'Veyangalla', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (299, 0, NULL, 0, NULL, 0, NULL, 'Wadduwa', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (300, 0, NULL, 0, NULL, 0, NULL, 'Walagedara', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (301, 0, NULL, 0, NULL, 0, NULL, 'Walallawita', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (302, 0, NULL, 0, NULL, 0, NULL, 'Waskaduwa', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (303, 0, NULL, 0, NULL, 0, NULL, 'Welipenna', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (304, 0, NULL, 0, NULL, 0, NULL, 'Welmilla Junction', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (305, 0, NULL, 0, NULL, 0, NULL, 'Yagirala', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (306, 0, NULL, 0, NULL, 0, NULL, 'Yatadolawatta', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (307, 0, NULL, 0, NULL, 0, NULL, 'Yatawara Junction', 'CI', 'A', 13);
INSERT INTO `geo_area` VALUES (308, 0, NULL, 0, NULL, 0, NULL, 'Adikarigama', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (309, 0, NULL, 0, NULL, 0, NULL, 'Akurana', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (310, 0, NULL, 0, NULL, 0, NULL, 'Alawatugoda', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (311, 0, NULL, 0, NULL, 0, NULL, 'Aludenia', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (312, 0, NULL, 0, NULL, 0, NULL, 'Ambagahapelessa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (313, 0, NULL, 0, NULL, 0, NULL, 'Ambatenna', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (314, 0, NULL, 0, NULL, 0, NULL, 'Ampitia', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (315, 0, NULL, 0, NULL, 0, NULL, 'Ankumbura', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (316, 0, NULL, 0, NULL, 0, NULL, 'Atabage', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (317, 0, NULL, 0, NULL, 0, NULL, 'Balana', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (318, 0, NULL, 0, NULL, 0, NULL, 'Bambaragahaela', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (319, 0, NULL, 0, NULL, 0, NULL, 'Barawardhana Oya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (320, 0, NULL, 0, NULL, 0, NULL, 'Batagolladeniya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (321, 0, NULL, 0, NULL, 0, NULL, 'Batugoda', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (322, 0, NULL, 0, NULL, 0, NULL, 'Batumulla', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (323, 0, NULL, 0, NULL, 0, NULL, 'Bawlana', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (324, 0, NULL, 0, NULL, 0, NULL, 'Bopana', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (325, 0, NULL, 0, NULL, 0, NULL, 'Danture', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (326, 0, NULL, 0, NULL, 0, NULL, 'Dedunupitiya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (327, 0, NULL, 0, NULL, 0, NULL, 'Dekinda', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (328, 0, NULL, 0, NULL, 0, NULL, 'Deltara', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (329, 0, NULL, 0, NULL, 0, NULL, 'Doragamuwa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (330, 0, NULL, 0, NULL, 0, NULL, 'Dolapihilla', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (331, 0, NULL, 0, NULL, 0, NULL, 'Dolosbage', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (332, 0, NULL, 0, NULL, 0, NULL, 'Doluwa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (333, 0, NULL, 0, NULL, 0, NULL, 'Dunuwila', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (334, 0, NULL, 0, NULL, 0, NULL, 'Ekiriya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (335, 0, NULL, 0, NULL, 0, NULL, 'Elamulla', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (336, 0, NULL, 0, NULL, 0, NULL, 'Etulgam', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (337, 0, NULL, 0, NULL, 0, NULL, 'Galaboda', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (338, 0, NULL, 0, NULL, 0, NULL, 'Galagedara', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (339, 0, NULL, 0, NULL, 0, NULL, 'Galaha', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (340, 0, NULL, 0, NULL, 0, NULL, 'Galhinna', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (341, 0, NULL, 0, NULL, 0, NULL, 'Gallellagama', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (342, 0, NULL, 0, NULL, 0, NULL, 'Gampola', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (343, 0, NULL, 0, NULL, 0, NULL, 'Gelioya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (344, 0, NULL, 0, NULL, 0, NULL, 'Godamunna', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (345, 0, NULL, 0, NULL, 0, NULL, 'Gomagoda', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (346, 0, NULL, 0, NULL, 0, NULL, 'Gonagantenna', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (347, 0, NULL, 0, NULL, 0, NULL, 'Gonawalapatana', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (348, 0, NULL, 0, NULL, 0, NULL, 'Gurudeniya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (349, 0, NULL, 0, NULL, 0, NULL, 'Gunnepana', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (350, 0, NULL, 0, NULL, 0, NULL, 'Halloluwa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (351, 0, NULL, 0, NULL, 0, NULL, 'Handaganawa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (352, 0, NULL, 0, NULL, 0, NULL, 'Handessa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (353, 0, NULL, 0, NULL, 0, NULL, 'Hataraliyadda', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (354, 0, NULL, 0, NULL, 0, NULL, 'Hondiyadeniya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (355, 0, NULL, 0, NULL, 0, NULL, 'Handawalapitiya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (356, 0, NULL, 0, NULL, 0, NULL, 'Hanguranketha', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (357, 0, NULL, 0, NULL, 0, NULL, 'Harankahawa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (358, 0, NULL, 0, NULL, 0, NULL, 'Hasalaka', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (359, 0, NULL, 0, NULL, 0, NULL, 'Hewaheta', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (360, 0, NULL, 0, NULL, 0, NULL, 'Hindagala', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (361, 0, NULL, 0, NULL, 0, NULL, 'Honduras', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (362, 0, NULL, 0, NULL, 0, NULL, 'Hunnasgiriya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (363, 0, NULL, 0, NULL, 0, NULL, 'Jambugahapitiya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (364, 0, NULL, 0, NULL, 0, NULL, 'Kadugannawa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (365, 0, NULL, 0, NULL, 0, NULL, 'Kahataliyada', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (366, 0, NULL, 0, NULL, 0, NULL, 'Kaluga', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (367, 0, NULL, 0, NULL, 0, NULL, 'Kandy', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (368, 0, NULL, 0, NULL, 0, NULL, 'Karandagolla', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (369, 0, NULL, 0, NULL, 0, NULL, 'Kahatagollewa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (370, 0, NULL, 0, NULL, 0, NULL, 'Kapuliyadde', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (371, 0, NULL, 0, NULL, 0, NULL, 'Katugastota', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (372, 0, NULL, 0, NULL, 0, NULL, 'Kengalla', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (373, 0, NULL, 0, NULL, 0, NULL, 'Ketakumbura', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (374, 0, NULL, 0, NULL, 0, NULL, 'Ketawala Leula', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (375, 0, NULL, 0, NULL, 0, NULL, 'Kiribathkumbura', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (376, 0, NULL, 0, NULL, 0, NULL, 'Kolabissa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (377, 0, NULL, 0, NULL, 0, NULL, 'Kolongoda', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (378, 0, NULL, 0, NULL, 0, NULL, 'Kulugammana', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (379, 0, NULL, 0, NULL, 0, NULL, 'Kumbukkandura', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (380, 0, NULL, 0, NULL, 0, NULL, 'Kumburegama', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (381, 0, NULL, 0, NULL, 0, NULL, 'Kundasale', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (382, 0, NULL, 0, NULL, 0, NULL, 'Leemagahakotuwa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (383, 0, NULL, 0, NULL, 0, NULL, 'Lhala Kobbekaduwa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (384, 0, NULL, 0, NULL, 0, NULL, 'lllagolla', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (385, 0, NULL, 0, NULL, 0, NULL, 'Lunuketiya Maditta', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (386, 0, NULL, 0, NULL, 0, NULL, 'Madawala Bazaar', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (387, 0, NULL, 0, NULL, 0, NULL, 'Madugalla', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (388, 0, NULL, 0, NULL, 0, NULL, 'Madulkele', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (389, 0, NULL, 0, NULL, 0, NULL, 'Mahadoraliyadda', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (390, 0, NULL, 0, NULL, 0, NULL, 'Mahamedagama', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (391, 0, NULL, 0, NULL, 0, NULL, 'Mailapitiya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (392, 0, NULL, 0, NULL, 0, NULL, 'Makkanigama', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (393, 0, NULL, 0, NULL, 0, NULL, 'Makuldenia', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (394, 0, NULL, 0, NULL, 0, NULL, 'Mandaram Nuwara', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (395, 0, NULL, 0, NULL, 0, NULL, 'Mapakanda', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (396, 0, NULL, 0, NULL, 0, NULL, 'Marassana', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (397, 0, NULL, 0, NULL, 0, NULL, 'Marymount Colony', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (398, 0, NULL, 0, NULL, 0, NULL, 'Maturata', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (399, 0, NULL, 0, NULL, 0, NULL, 'Mawatura', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (400, 0, NULL, 0, NULL, 0, NULL, 'Medamahanuwara', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (401, 0, NULL, 0, NULL, 0, NULL, 'MedawalaHarispattuwa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (402, 0, NULL, 0, NULL, 0, NULL, 'Megoda Kalugamuwa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (403, 0, NULL, 0, NULL, 0, NULL, 'Menikdiwela', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (404, 0, NULL, 0, NULL, 0, NULL, 'Meetalawa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (405, 0, NULL, 0, NULL, 0, NULL, 'Menikhinna', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (406, 0, NULL, 0, NULL, 0, NULL, 'Mimure', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (407, 0, NULL, 0, NULL, 0, NULL, 'Minigamuwa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (408, 0, NULL, 0, NULL, 0, NULL, 'Minipe', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (409, 0, NULL, 0, NULL, 0, NULL, 'Naranpanawa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (410, 0, NULL, 0, NULL, 0, NULL, 'Nattarampotha', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (411, 0, NULL, 0, NULL, 0, NULL, 'Nawalapitiya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (412, 0, NULL, 0, NULL, 0, NULL, 'Nillambe', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (413, 0, NULL, 0, NULL, 0, NULL, 'Nugaliyadda', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (414, 0, NULL, 0, NULL, 0, NULL, 'Nugawela', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (415, 0, NULL, 0, NULL, 0, NULL, 'Pallebowala', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (416, 0, NULL, 0, NULL, 0, NULL, 'Pallekotuwa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (417, 0, NULL, 0, NULL, 0, NULL, 'Panvila', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (418, 0, NULL, 0, NULL, 0, NULL, 'Paradeka', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (419, 0, NULL, 0, NULL, 0, NULL, 'Pasbage', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (420, 0, NULL, 0, NULL, 0, NULL, 'Pattiya Watta', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (421, 0, NULL, 0, NULL, 0, NULL, 'Panwilatenna', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (422, 0, NULL, 0, NULL, 0, NULL, 'Pattitalawa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (423, 0, NULL, 0, NULL, 0, NULL, 'Peradeniya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (424, 0, NULL, 0, NULL, 0, NULL, 'Pilawala', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (425, 0, NULL, 0, NULL, 0, NULL, 'Pilimatalawa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (426, 0, NULL, 0, NULL, 0, NULL, 'Poholiyadda', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (427, 0, NULL, 0, NULL, 0, NULL, 'Polgola', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (428, 0, NULL, 0, NULL, 0, NULL, 'Pujapitiya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (429, 0, NULL, 0, NULL, 0, NULL, 'Pupuressa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (430, 0, NULL, 0, NULL, 0, NULL, 'Putuhapuwa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (431, 0, NULL, 0, NULL, 0, NULL, 'Pussellawa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (432, 0, NULL, 0, NULL, 0, NULL, 'Puwakpitiya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (433, 0, NULL, 0, NULL, 0, NULL, 'Rajawella', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (434, 0, NULL, 0, NULL, 0, NULL, 'Rambukpitiya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (435, 0, NULL, 0, NULL, 0, NULL, 'Rambukwella', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (436, 0, NULL, 0, NULL, 0, NULL, 'Rangala', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (437, 0, NULL, 0, NULL, 0, NULL, 'Rantembe', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (438, 0, NULL, 0, NULL, 0, NULL, 'Rikillagaskada', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (439, 0, NULL, 0, NULL, 0, NULL, 'Rathukhodigala', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (440, 0, NULL, 0, NULL, 0, NULL, 'Sangarajapura', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (441, 0, NULL, 0, NULL, 0, NULL, 'Senarathwela', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (442, 0, NULL, 0, NULL, 0, NULL, 'Talatuoya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (443, 0, NULL, 0, NULL, 0, NULL, 'Tawalantenna', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (444, 0, NULL, 0, NULL, 0, NULL, 'Teldeniya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (445, 0, NULL, 0, NULL, 0, NULL, 'Tennekumbura', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (446, 0, NULL, 0, NULL, 0, NULL, 'Uda Peradeniya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (447, 0, NULL, 0, NULL, 0, NULL, 'Udahentenna', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (448, 0, NULL, 0, NULL, 0, NULL, 'Udahingulwala', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (449, 0, NULL, 0, NULL, 0, NULL, 'Udatalawinna', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (450, 0, NULL, 0, NULL, 0, NULL, 'Udawatta', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (451, 0, NULL, 0, NULL, 0, NULL, 'Udispattuwa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (452, 0, NULL, 0, NULL, 0, NULL, 'Ududumbara', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (453, 0, NULL, 2, '2023-04-21 09:22:31.000000', 2, NULL, 'Uduwa', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (454, 0, NULL, 0, NULL, 0, NULL, 'Uduahinna', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (455, 0, NULL, 0, NULL, 0, NULL, 'Uduwela', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (456, 0, NULL, 0, NULL, 0, NULL, 'Ulapane', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (457, 0, NULL, 0, NULL, 0, NULL, 'Ulpothagama', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (458, 0, NULL, 0, NULL, 0, NULL, 'Unuwinna', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (459, 0, NULL, 0, NULL, 0, NULL, 'Velamboda', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (460, 0, NULL, 0, NULL, 0, NULL, 'Wattappola', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (461, 0, NULL, 0, NULL, 0, NULL, 'Wattegama', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (462, 0, NULL, 0, NULL, 0, NULL, 'Weligalla', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (463, 0, NULL, 0, NULL, 0, NULL, 'Weligampola', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (464, 0, NULL, 0, NULL, 0, NULL, 'Weragantota', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (465, 0, NULL, 0, NULL, 0, NULL, 'Werapitiya', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (466, 0, NULL, 0, NULL, 0, NULL, 'Werellagama', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (467, 0, NULL, 0, NULL, 0, NULL, 'Yahalatenna', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (468, 0, NULL, 0, NULL, 0, NULL, 'Yatihalagala', 'CI', 'A', 14);
INSERT INTO `geo_area` VALUES (469, 0, NULL, 0, NULL, 0, NULL, 'Akuramboda', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (470, 0, NULL, 0, NULL, 0, NULL, 'Alwatta', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (471, 0, NULL, 0, NULL, 0, NULL, 'Ambana', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (472, 0, NULL, 0, NULL, 0, NULL, 'Ataragallewa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (473, 0, NULL, 0, NULL, 0, NULL, 'Bambaragaswewa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (474, 0, NULL, 0, NULL, 0, NULL, 'Beligamuwa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (475, 0, NULL, 0, NULL, 0, NULL, 'Dambulla', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (476, 0, NULL, 0, NULL, 0, NULL, 'Dankanda', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (477, 0, NULL, 0, NULL, 0, NULL, 'Devagiriya', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (478, 0, NULL, 0, NULL, 0, NULL, 'Dewahuwa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (479, 0, NULL, 0, NULL, 0, NULL, 'Dullewa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (480, 0, NULL, 0, NULL, 0, NULL, 'Dunkolawatta', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (481, 0, NULL, 0, NULL, 0, NULL, 'Dunuwilapitiya', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (482, 0, NULL, 0, NULL, 0, NULL, 'Elkaduwa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (483, 0, NULL, 0, NULL, 0, NULL, 'Erawula Junction', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (484, 0, NULL, 0, NULL, 0, NULL, 'Etanawala', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (485, 0, NULL, 0, NULL, 0, NULL, 'Galewela', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (486, 0, NULL, 0, NULL, 0, NULL, 'Gammaduwa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (487, 0, NULL, 0, NULL, 0, NULL, 'Gangala', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (488, 0, NULL, 0, NULL, 0, NULL, 'Handungamuwa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (489, 0, NULL, 0, NULL, 0, NULL, 'Hattota Amuna', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (490, 0, NULL, 0, NULL, 0, NULL, 'Imbulgolla', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (491, 0, NULL, 0, NULL, 0, NULL, 'Inamaluwa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (492, 0, NULL, 0, NULL, 0, NULL, 'Kaikawala', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (493, 0, NULL, 0, NULL, 0, NULL, 'Kalundawa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (494, 0, NULL, 0, NULL, 0, NULL, 'Kandalama', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (495, 0, NULL, 0, NULL, 0, NULL, 'Karagahinna', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (496, 0, NULL, 0, NULL, 0, NULL, 'Katudeniya', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (497, 0, NULL, 0, NULL, 0, NULL, 'Kavudupelella', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (498, 0, NULL, 0, NULL, 0, NULL, 'Kibissa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (499, 0, NULL, 0, NULL, 0, NULL, 'Kiwula', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (500, 0, NULL, 0, NULL, 0, NULL, 'Kongahawela', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (501, 0, NULL, 0, NULL, 0, NULL, 'Laggala Pallegama', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (502, 0, NULL, 0, NULL, 0, NULL, 'Leliambe', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (503, 0, NULL, 0, NULL, 0, NULL, 'Lenadora', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (504, 0, NULL, 0, NULL, 0, NULL, 'lllukkumbura', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (505, 0, NULL, 0, NULL, 0, NULL, 'Madawala', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (506, 0, NULL, 0, NULL, 0, NULL, 'Madipola', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (507, 0, NULL, 0, NULL, 0, NULL, 'Mahawela', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (508, 0, NULL, 0, NULL, 0, NULL, 'Mananwatta', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (509, 0, NULL, 0, NULL, 0, NULL, 'Maraka', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (510, 0, NULL, 0, NULL, 0, NULL, 'Matale', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (511, 0, NULL, 0, NULL, 0, NULL, 'Melipitiya', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (512, 0, NULL, 0, NULL, 0, NULL, 'Metihakka', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (513, 0, NULL, 0, NULL, 0, NULL, 'Millawana', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (514, 0, NULL, 0, NULL, 0, NULL, 'Muwandeniya', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (515, 0, NULL, 0, NULL, 0, NULL, 'Nalanda', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (516, 0, NULL, 0, NULL, 0, NULL, 'Naula', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (517, 0, NULL, 0, NULL, 0, NULL, 'Nugagolla', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (518, 0, NULL, 0, NULL, 0, NULL, 'Opalgala', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (519, 0, NULL, 0, NULL, 0, NULL, 'Ovilikanda', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (520, 0, NULL, 0, NULL, 0, NULL, 'Palapathwela', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (521, 0, NULL, 0, NULL, 0, NULL, 'Pallepola', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (522, 0, NULL, 0, NULL, 0, NULL, 'Perakanatta', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (523, 0, NULL, 0, NULL, 0, NULL, 'Pallepola', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (524, 0, NULL, 0, NULL, 0, NULL, 'Pubbiliya', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (525, 0, NULL, 0, NULL, 0, NULL, 'Dambulla', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (526, 0, NULL, 0, NULL, 0, NULL, 'Dankanda', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (527, 0, NULL, 0, NULL, 0, NULL, 'Devagiriya', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (528, 0, NULL, 0, NULL, 0, NULL, 'Dewahuwa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (529, 0, NULL, 0, NULL, 0, NULL, 'Dullewa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (530, 0, NULL, 0, NULL, 0, NULL, 'Dunkolawatta', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (531, 0, NULL, 0, NULL, 0, NULL, 'Dunuwilapitiya', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (532, 0, NULL, 0, NULL, 0, NULL, 'Elkaduwa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (533, 0, NULL, 0, NULL, 0, NULL, 'Erawula Junction', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (534, 0, NULL, 0, NULL, 0, NULL, 'Etanawala', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (535, 0, NULL, 0, NULL, 0, NULL, 'Galewela', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (536, 0, NULL, 0, NULL, 0, NULL, 'Gammaduwa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (537, 0, NULL, 0, NULL, 0, NULL, 'Gangala', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (538, 0, NULL, 0, NULL, 0, NULL, 'Ranamuregama', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (539, 0, NULL, 0, NULL, 0, NULL, 'Siginya', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (540, 0, NULL, 0, NULL, 0, NULL, 'Talagoda Junction', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (541, 0, NULL, 0, NULL, 0, NULL, 'Talakiriyagama', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (542, 0, NULL, 0, NULL, 0, NULL, 'Udasgiriya', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (543, 0, NULL, 0, NULL, 0, NULL, 'Udatenna', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (544, 0, NULL, 0, NULL, 0, NULL, 'Walawela', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (545, 0, NULL, 0, NULL, 0, NULL, 'Welangahawatte', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (546, 0, NULL, 0, NULL, 0, NULL, 'Wewalawewa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (547, 0, NULL, 0, NULL, 0, NULL, 'Wilgamuwa', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (548, 0, NULL, 0, NULL, 0, NULL, 'Yatawatta', 'CI', 'A', 15);
INSERT INTO `geo_area` VALUES (549, 0, NULL, 0, NULL, 0, NULL, 'Agarapathana', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (550, 0, NULL, 0, NULL, 0, NULL, 'Ambagamuwa', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (551, 0, NULL, 0, NULL, 0, NULL, 'Ambatalawa', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (552, 0, NULL, 0, NULL, 0, NULL, 'Ambewela', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (553, 0, NULL, 0, NULL, 0, NULL, 'Bogawantalawa', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (554, 0, NULL, 0, NULL, 0, NULL, 'Bopattalawa', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (555, 0, NULL, 0, NULL, 0, NULL, 'Dagampitiya', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (556, 0, NULL, 0, NULL, 0, NULL, 'Dayagama Bazaar', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (557, 0, NULL, 0, NULL, 0, NULL, 'Dikoya', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (558, 0, NULL, 0, NULL, 0, NULL, 'Doragala', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (559, 0, NULL, 0, NULL, 0, NULL, 'Dunukedeniya', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (560, 0, NULL, 0, NULL, 0, NULL, 'Ginigathena', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (561, 0, NULL, 0, NULL, 0, NULL, 'Gonakele', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (562, 0, NULL, 0, NULL, 0, NULL, 'Haggala', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (563, 0, NULL, 0, NULL, 0, NULL, 'Halgranoya', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (564, 0, NULL, 0, NULL, 0, NULL, 'Hangarapitiya', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (565, 0, NULL, 0, NULL, 0, NULL, 'Hapugastalawa', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (566, 0, NULL, 0, NULL, 0, NULL, 'Harangalagama', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (567, 0, NULL, 0, NULL, 0, NULL, 'Harasbedda', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (568, 0, NULL, 0, NULL, 0, NULL, 'Hatton', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (569, 0, NULL, 0, NULL, 0, NULL, 'Hedunuwewa', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (570, 0, NULL, 0, NULL, 0, NULL, 'Hitigegama', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (571, 0, NULL, 0, NULL, 0, NULL, 'Kalaganwatta', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (572, 0, NULL, 0, NULL, 0, NULL, 'Kandapola', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (573, 0, NULL, 0, NULL, 0, NULL, 'Katukitula', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (574, 0, NULL, 0, NULL, 0, NULL, 'Keerthi Bandarapura', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (575, 0, NULL, 0, NULL, 0, NULL, 'Kelanigama', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (576, 0, NULL, 0, NULL, 0, NULL, 'Ketaboola', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (577, 0, NULL, 0, NULL, 0, NULL, 'Kotagala', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (578, 0, NULL, 0, NULL, 0, NULL, 'Kotmale', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (579, 0, NULL, 0, NULL, 0, NULL, 'Kumbalgamuwa', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (580, 0, NULL, 0, NULL, 0, NULL, 'Kumbukwela', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (581, 0, NULL, 0, NULL, 0, NULL, 'Kurupanawela', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (582, 0, NULL, 0, NULL, 0, NULL, 'Labukele', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (583, 0, NULL, 0, NULL, 0, NULL, 'Laxapana', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (584, 0, NULL, 0, NULL, 0, NULL, 'Lindula', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (585, 0, NULL, 0, NULL, 0, NULL, 'Madulla', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (586, 0, NULL, 0, NULL, 0, NULL, 'Maldeniya', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (587, 0, NULL, 0, NULL, 0, NULL, 'Maskeliya', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (588, 0, NULL, 0, NULL, 0, NULL, 'Maswela', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (589, 0, NULL, 0, NULL, 0, NULL, 'Morahenagama', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (590, 0, NULL, 0, NULL, 0, NULL, 'Munwatta', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (591, 0, NULL, 0, NULL, 0, NULL, 'Nanuoya', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (592, 0, NULL, 0, NULL, 0, NULL, 'Nawathispane', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (593, 0, NULL, 0, NULL, 0, NULL, 'Nayapana Janapadaya', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (594, 0, NULL, 0, NULL, 0, NULL, 'Nildandahinna', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (595, 0, NULL, 0, NULL, 0, NULL, 'Nissanka Uyana', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (596, 0, NULL, 0, NULL, 0, NULL, 'Norwood', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (597, 0, NULL, 0, NULL, 0, NULL, 'Padiyapelella', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (598, 0, NULL, 0, NULL, 0, NULL, 'Patana', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (599, 0, NULL, 0, NULL, 0, NULL, 'Pitawala', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (600, 0, NULL, 0, NULL, 0, NULL, 'Pundaluoya', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (601, 0, NULL, 0, NULL, 0, NULL, 'Ramboda', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (602, 0, NULL, 0, NULL, 0, NULL, 'Rozella', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (603, 0, NULL, 0, NULL, 0, NULL, 'Rupaha', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (604, 0, NULL, 0, NULL, 0, NULL, 'Ruwaneliya', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (605, 0, NULL, 0, NULL, 0, NULL, 'Santhipura', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (606, 0, NULL, 0, NULL, 0, NULL, 'Thalawakale', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (607, 0, NULL, 0, NULL, 0, NULL, 'Teripeha', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (608, 0, NULL, 0, NULL, 0, NULL, 'Udamadura', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (609, 0, NULL, 0, NULL, 0, NULL, 'Udapussallawa', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (610, 0, NULL, 0, NULL, 0, NULL, 'Walapane', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (611, 0, NULL, 0, NULL, 0, NULL, 'Watagoda', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (612, 0, NULL, 0, NULL, 0, NULL, 'Watawala', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (613, 0, NULL, 0, NULL, 0, NULL, 'Addalaichenai', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (614, 0, NULL, 0, NULL, 0, NULL, 'Akkaraipattu', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (615, 0, NULL, 0, NULL, 0, NULL, 'Ampara', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (616, 0, NULL, 0, NULL, 0, NULL, 'Bakmitiyawa', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (617, 0, NULL, 0, NULL, 0, NULL, 'Central Camp', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (618, 0, NULL, 0, NULL, 0, NULL, 'Dadayamtalawa', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (619, 0, NULL, 0, NULL, 0, NULL, 'Damana', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (620, 0, NULL, 0, NULL, 0, NULL, 'Damanewela', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (621, 0, NULL, 0, NULL, 0, NULL, 'Deegawapiya', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (622, 0, NULL, 0, NULL, 0, NULL, 'Dehiattakandiya', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (623, 0, NULL, 0, NULL, 0, NULL, 'Devalahinda', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (624, 0, NULL, 0, NULL, 0, NULL, 'Digamadulla', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (625, 0, NULL, 0, NULL, 0, NULL, 'Dorakumbura', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (626, 0, NULL, 0, NULL, 0, NULL, 'Galapitagala', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (627, 0, NULL, 0, NULL, 0, NULL, 'Gonagolla', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (628, 0, NULL, 0, NULL, 0, NULL, 'Hingurana', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (629, 0, NULL, 0, NULL, 0, NULL, 'Hulannuge', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (630, 0, NULL, 0, NULL, 0, NULL, 'Kalmunai', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (631, 0, NULL, 0, NULL, 0, NULL, 'Kannakipuram', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (632, 0, NULL, 0, NULL, 0, NULL, 'Kekirihena', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (633, 0, NULL, 0, NULL, 0, NULL, 'Koknahara', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (634, 0, NULL, 0, NULL, 0, NULL, 'Kolamanthalawa', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (635, 0, NULL, 0, NULL, 0, NULL, 'Labunoruwa', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (636, 0, NULL, 0, NULL, 0, NULL, 'lmkkamam', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (637, 0, NULL, 0, NULL, 0, NULL, 'Madawalalanda', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (638, 0, NULL, 0, NULL, 0, NULL, 'Mahanagapura', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (639, 0, NULL, 0, NULL, 0, NULL, 'Mahaoya', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (640, 0, NULL, 0, NULL, 0, NULL, 'Malwatta', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (641, 0, NULL, 0, NULL, 0, NULL, 'Mangalagama', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (642, 0, NULL, 0, NULL, 0, NULL, 'Marathamune', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (643, 0, NULL, 0, NULL, 0, NULL, 'Mawanagama', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (644, 0, NULL, 0, NULL, 0, NULL, 'Namaloya', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (645, 0, NULL, 0, NULL, 0, NULL, 'Nawamedagama', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (646, 0, NULL, 0, NULL, 0, NULL, 'Nelliady', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (647, 0, NULL, 0, NULL, 0, NULL, 'Nelliyadda', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (648, 0, NULL, 0, NULL, 0, NULL, 'Oluvil', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (649, 0, NULL, 0, NULL, 0, NULL, 'Padiyatalawa', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (650, 0, NULL, 0, NULL, 0, NULL, 'Pahalalanda', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (651, 0, NULL, 0, NULL, 0, NULL, 'Palamunai', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (652, 0, NULL, 0, NULL, 0, NULL, 'Panama', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (653, 0, NULL, 0, NULL, 0, NULL, 'Pannalagama', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (654, 0, NULL, 0, NULL, 0, NULL, 'Paragahakele', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (655, 0, NULL, 0, NULL, 0, NULL, 'Periyaneelavanai', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (656, 0, NULL, 0, NULL, 0, NULL, 'Polwaga Janapadaya', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (657, 0, NULL, 0, NULL, 0, NULL, 'Pottuvil', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (658, 0, NULL, 0, NULL, 0, NULL, 'Rajagalatenna', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (659, 0, NULL, 0, NULL, 0, NULL, 'Sainthamaruthu', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (660, 0, NULL, 0, NULL, 0, NULL, 'Samanthurai', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (661, 0, NULL, 0, NULL, 0, NULL, 'Serankada', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (662, 0, NULL, 0, NULL, 0, NULL, 'Siripura', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (663, 0, NULL, 0, NULL, 0, NULL, 'Siyambalawewa', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (664, 0, NULL, 0, NULL, 0, NULL, 'Tempitiya', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (665, 0, NULL, 0, NULL, 0, NULL, 'Thambiluvil', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (666, 0, NULL, 0, NULL, 0, NULL, 'Tirukovil', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (667, 0, NULL, 0, NULL, 0, NULL, 'Uhana', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (668, 0, NULL, 0, NULL, 0, NULL, 'Wadinagala', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (669, 0, NULL, 0, NULL, 0, NULL, 'Wanagamuwa', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (670, 0, NULL, 0, NULL, 0, NULL, 'Werunketagoda', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (671, 0, NULL, 0, NULL, 0, NULL, 'Karativu', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (672, 0, NULL, 0, NULL, 0, NULL, 'Komari', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (673, 0, NULL, 0, NULL, 0, NULL, 'Lahugala', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (674, 0, NULL, 0, NULL, 0, NULL, 'Nintavur', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (675, 0, NULL, 0, NULL, 0, NULL, 'Sainthamamthu', 'CI', 'A', 17);
INSERT INTO `geo_area` VALUES (676, 0, NULL, 0, NULL, 0, NULL, 'Ampilanthurai', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (677, 0, NULL, 0, NULL, 0, NULL, 'Araipattai', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (678, 0, NULL, 0, NULL, 0, NULL, 'Ayithiyamalai', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (679, 0, NULL, 0, NULL, 0, NULL, 'Bakiella', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (680, 0, NULL, 0, NULL, 0, NULL, 'Batticaloa', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (681, 0, NULL, 0, NULL, 0, NULL, 'Cheddipalayam', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (682, 0, NULL, 0, NULL, 0, NULL, 'Chenkaladi', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (683, 0, NULL, 0, NULL, 0, NULL, 'Eravur', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (684, 0, NULL, 0, NULL, 0, NULL, 'Kalkudah', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (685, 0, NULL, 0, NULL, 0, NULL, 'Kallar', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (686, 0, NULL, 0, NULL, 0, NULL, 'Kaluwanchikudi', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (687, 0, NULL, 0, NULL, 0, NULL, 'Kaluwankemy', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (688, 0, NULL, 0, NULL, 0, NULL, 'Kannankudah', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (689, 0, NULL, 0, NULL, 0, NULL, 'Karadiyanaru', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (690, 0, NULL, 0, NULL, 0, NULL, 'Kattankudi', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (691, 0, NULL, 0, NULL, 0, NULL, 'Kiran', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (692, 0, NULL, 0, NULL, 0, NULL, 'Kirankulam', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (693, 0, NULL, 0, NULL, 0, NULL, 'Koddaikallar', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (694, 0, NULL, 0, NULL, 0, NULL, 'Kokkaddichcholai', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (695, 0, NULL, 0, NULL, 0, NULL, 'Kurukkalmadam', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (696, 0, NULL, 0, NULL, 0, NULL, 'Mandur', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (697, 0, NULL, 0, NULL, 0, NULL, 'Mankemi', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (698, 0, NULL, 0, NULL, 0, NULL, 'Navatkadu', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (699, 0, NULL, 0, NULL, 0, NULL, 'Oddamavadi', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (700, 0, NULL, 0, NULL, 0, NULL, 'Panichankemi', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (701, 0, NULL, 0, NULL, 0, NULL, 'Pankudavely', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (702, 0, NULL, 0, NULL, 0, NULL, 'Periyaporativu', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (703, 0, NULL, 0, NULL, 0, NULL, 'Periyapullumalai', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (704, 0, NULL, 0, NULL, 0, NULL, 'Pillaiyaradi', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (705, 0, NULL, 0, NULL, 0, NULL, 'Punanai', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (706, 0, NULL, 0, NULL, 0, NULL, 'Puthukudiyiruppu', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (707, 0, NULL, 0, NULL, 0, NULL, 'Sittandy', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (708, 0, NULL, 0, NULL, 0, NULL, 'Thannamunai', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (709, 0, NULL, 0, NULL, 0, NULL, 'Thettativu', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (710, 0, NULL, 0, NULL, 0, NULL, 'Thikkodai', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (711, 0, NULL, 0, NULL, 0, NULL, 'Thirupalugamam', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (712, 0, NULL, 0, NULL, 0, NULL, 'Thuraineelavanai', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (713, 0, NULL, 0, NULL, 0, NULL, 'Unnichchai', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (714, 0, NULL, 0, NULL, 0, NULL, 'Vakaneri', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (715, 0, NULL, 0, NULL, 0, NULL, 'Vakarai', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (716, 0, NULL, 0, NULL, 0, NULL, 'Valaichenai', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (717, 0, NULL, 0, NULL, 0, NULL, 'Vantharumoolai', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (718, 0, NULL, 0, NULL, 0, NULL, 'Vellavely', 'CI', 'A', 18);
INSERT INTO `geo_area` VALUES (719, 0, NULL, 0, NULL, 0, NULL, 'Agbopura', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (720, 0, NULL, 0, NULL, 0, NULL, 'Buckmigama', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (721, 0, NULL, 0, NULL, 0, NULL, 'Chinabay', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (722, 0, NULL, 0, NULL, 0, NULL, 'Dehiwatte', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (723, 0, NULL, 0, NULL, 0, NULL, 'Echchilampattai', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (724, 0, NULL, 0, NULL, 0, NULL, 'Galmetiyawa', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (725, 0, NULL, 0, NULL, 0, NULL, 'Gomarankadawala', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (726, 0, NULL, 0, NULL, 0, NULL, 'Kaddaiparichchan', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (727, 0, NULL, 0, NULL, 0, NULL, 'Kanniya', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (728, 0, NULL, 0, NULL, 0, NULL, 'Kantalai', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (729, 0, NULL, 0, NULL, 0, NULL, 'KantalaiSugarFactory', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (730, 0, NULL, 0, NULL, 0, NULL, 'Kiliveddy', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (731, 0, NULL, 0, NULL, 0, NULL, 'Kinniya', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (732, 0, NULL, 0, NULL, 0, NULL, 'Kuchchaveli', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (733, 0, NULL, 0, NULL, 0, NULL, 'Kumburupiddy', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (734, 0, NULL, 0, NULL, 0, NULL, 'Kurinchakemy', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (735, 0, NULL, 0, NULL, 0, NULL, 'Lankapatuna', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (736, 0, NULL, 0, NULL, 0, NULL, 'Mahadivulwewa', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (737, 0, NULL, 0, NULL, 0, NULL, 'Maharugiramam', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (738, 0, NULL, 0, NULL, 0, NULL, 'Mallikativu', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (739, 0, NULL, 0, NULL, 0, NULL, 'Mawadichenai', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (740, 0, NULL, 0, NULL, 0, NULL, 'Mullipothana', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (741, 0, NULL, 0, NULL, 0, NULL, 'Neelapola', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (742, 0, NULL, 0, NULL, 0, NULL, 'Nilaveli', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (743, 0, NULL, 0, NULL, 0, NULL, 'Pankulam', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (744, 0, NULL, 0, NULL, 0, NULL, 'Rottawewa', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (745, 0, NULL, 0, NULL, 0, NULL, 'Sampaltivu', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (746, 0, NULL, 0, NULL, 0, NULL, 'Sampur', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (747, 0, NULL, 0, NULL, 0, NULL, 'Serunuwara', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (748, 0, NULL, 0, NULL, 0, NULL, 'Seruwila', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (749, 0, NULL, 0, NULL, 0, NULL, 'Sirajnagar', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (750, 0, NULL, 0, NULL, 0, NULL, 'Somapura', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (751, 0, NULL, 0, NULL, 0, NULL, 'Tampalakamam', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (752, 0, NULL, 0, NULL, 0, NULL, 'Tiriyayi', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (753, 0, NULL, 0, NULL, 0, NULL, 'Toppur', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (754, 0, NULL, 0, NULL, 0, NULL, 'Trincomalee', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (755, 0, NULL, 0, NULL, 0, NULL, 'Vellamanal', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (756, 0, NULL, 0, NULL, 0, NULL, 'Wanela', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (757, 0, NULL, 0, NULL, 0, NULL, 'Jaffna', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (758, 0, NULL, 0, NULL, 0, NULL, 'Atchchuveli', 'CI', 'A', 20);
INSERT INTO `geo_area` VALUES (759, 0, NULL, 0, NULL, 0, NULL, 'Chavakachcheri', 'CI', 'A', 20);
INSERT INTO `geo_area` VALUES (760, 0, NULL, 0, NULL, 0, NULL, 'Chunnakam', 'CI', 'A', 20);
INSERT INTO `geo_area` VALUES (761, 0, NULL, 0, NULL, 0, NULL, 'Kankasanthurai', 'CI', 'A', 20);
INSERT INTO `geo_area` VALUES (762, 0, NULL, 0, NULL, 0, NULL, 'Karainagar', 'CI', 'A', 20);
INSERT INTO `geo_area` VALUES (763, 0, NULL, 0, NULL, 0, NULL, 'Manipay', 'CI', 'A', 20);
INSERT INTO `geo_area` VALUES (764, 0, NULL, 0, NULL, 0, NULL, 'Point pedro', 'CI', 'A', 20);
INSERT INTO `geo_area` VALUES (765, 0, NULL, 2, '2023-05-22 06:44:50.000000', 4, NULL, 'Kilinochchi', 'CI', 'A', 21);
INSERT INTO `geo_area` VALUES (766, 0, NULL, 0, NULL, 0, NULL, 'Mannar', 'CI', 'A', 22);
INSERT INTO `geo_area` VALUES (767, 0, NULL, 0, NULL, 0, NULL, 'Mankulam', 'CI', 'A', 23);
INSERT INTO `geo_area` VALUES (768, 0, NULL, 0, NULL, 0, NULL, 'Mullaitivu', 'CI', 'A', 23);
INSERT INTO `geo_area` VALUES (769, 0, NULL, 0, NULL, 0, NULL, 'Vavuniya', 'CI', 'A', 24);
INSERT INTO `geo_area` VALUES (770, 0, NULL, 0, NULL, 0, NULL, 'Agaliya', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (771, 0, NULL, 0, NULL, 0, NULL, 'Ahangama', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (772, 0, NULL, 0, NULL, 0, NULL, 'Ahungalla', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (773, 0, NULL, 0, NULL, 0, NULL, 'Akmeemana', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (774, 0, NULL, 0, NULL, 0, NULL, 'Aluthwala', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (775, 0, NULL, 0, NULL, 0, NULL, 'Ambalangoda', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (776, 0, NULL, 0, NULL, 0, NULL, 'Ampegama', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (777, 0, NULL, 0, NULL, 0, NULL, 'Amugoda', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (778, 0, NULL, 0, NULL, 0, NULL, 'Anangoda', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (779, 0, NULL, 0, NULL, 0, NULL, 'Angulugaha', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (780, 0, NULL, 0, NULL, 0, NULL, 'Ankokkawala', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (781, 0, NULL, 0, NULL, 0, NULL, 'Baddegama', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (782, 0, NULL, 0, NULL, 0, NULL, 'Balapitiya', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (783, 0, NULL, 0, NULL, 0, NULL, 'Banagala', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (784, 0, NULL, 0, NULL, 0, NULL, 'Batapola', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (785, 0, NULL, 0, NULL, 0, NULL, 'Bentota', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (786, 0, NULL, 0, NULL, 0, NULL, 'Boossa', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (787, 0, NULL, 0, NULL, 0, NULL, 'Dikkumbura', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (788, 0, NULL, 0, NULL, 0, NULL, 'Dodanduwa', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (789, 0, NULL, 0, NULL, 0, NULL, 'Ella Tanabaddegama', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (790, 0, NULL, 0, NULL, 0, NULL, 'Elpitiya', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (791, 0, NULL, 0, NULL, 0, NULL, 'Ethkandura', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (792, 0, NULL, 0, NULL, 0, NULL, 'Galle', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (793, 0, NULL, 0, NULL, 0, NULL, 'Ganegoda', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (794, 0, NULL, 0, NULL, 0, NULL, 'Ginimellagaha', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (795, 0, NULL, 0, NULL, 0, NULL, 'Gintota', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (796, 0, NULL, 0, NULL, 0, NULL, 'Godahena', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (797, 0, NULL, 0, NULL, 0, NULL, 'Gonagalpura', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (798, 0, NULL, 0, NULL, 0, NULL, 'Gonamulla', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (799, 0, NULL, 0, NULL, 0, NULL, 'Gonapinuwala', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (800, 0, NULL, 0, NULL, 0, NULL, 'Habaraduwa', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (801, 0, NULL, 0, NULL, 0, NULL, 'Haburugala', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (802, 0, NULL, 0, NULL, 0, NULL, 'Halvitigala', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (803, 0, NULL, 0, NULL, 0, NULL, 'Hawpe', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (804, 0, NULL, 0, NULL, 0, NULL, 'Hikkaduwa', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (805, 0, NULL, 0, NULL, 0, NULL, 'Hiniduma', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (806, 0, NULL, 0, NULL, 0, NULL, 'Hiyare', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (807, 0, NULL, 0, NULL, 0, NULL, 'Ihala Walpola', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (808, 0, NULL, 0, NULL, 0, NULL, 'Kahaduwa', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (809, 0, NULL, 0, NULL, 0, NULL, 'Kahawa', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (810, 0, NULL, 0, NULL, 0, NULL, 'Kananke Bazaar', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (811, 0, NULL, 0, NULL, 0, NULL, 'Karagoda', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (812, 0, NULL, 0, NULL, 0, NULL, 'Karandana', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (813, 0, NULL, 894, '2023-05-25 11:23:13.000000', 1, NULL, 'Karandeniya', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (814, 0, NULL, 0, NULL, 0, NULL, 'Kosgoda', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (815, 0, NULL, 0, NULL, 0, NULL, 'Kottawagama', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (816, 0, NULL, 0, NULL, 0, NULL, 'Kuleegoda', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (817, 0, NULL, 0, NULL, 0, NULL, 'lhalahewessa', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (818, 0, NULL, 0, NULL, 0, NULL, 'lmaduwa', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (819, 0, NULL, 0, NULL, 0, NULL, 'lnduruwa', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (820, 0, NULL, 0, NULL, 0, NULL, 'Magedara', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (821, 0, NULL, 0, NULL, 0, NULL, 'Magedara', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (822, 0, NULL, 0, NULL, 0, NULL, 'Malgalla Talangalla', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (823, 0, NULL, 0, NULL, 0, NULL, 'Mapalagama', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (824, 0, NULL, 0, NULL, 0, NULL, 'Mapalagama', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (825, 0, NULL, 0, NULL, 0, NULL, 'Mapalagama Central', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (826, 0, NULL, 0, NULL, 0, NULL, 'Mattaka', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (827, 0, NULL, 0, NULL, 0, NULL, 'Meda-Keembiya', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (828, 0, NULL, 0, NULL, 0, NULL, 'Meetiyagoda', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (829, 0, NULL, 0, NULL, 0, NULL, 'Nagoda', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (830, 0, NULL, 0, NULL, 0, NULL, 'Nakiyadeniya', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (831, 0, NULL, 0, NULL, 0, NULL, 'Nawadagala', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (832, 0, NULL, 0, NULL, 0, NULL, 'Neluwa', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (833, 0, NULL, 0, NULL, 0, NULL, 'Nindana', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (834, 0, NULL, 0, NULL, 0, NULL, 'Opatha', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (835, 0, NULL, 0, NULL, 0, NULL, 'Panangala', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (836, 0, NULL, 0, NULL, 0, NULL, 'Pannimulla anagoda', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (837, 0, NULL, 0, NULL, 0, NULL, 'ParanaThanaYamgoda', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (838, 0, NULL, 0, NULL, 0, NULL, 'Pitigala', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (839, 0, NULL, 0, NULL, 0, NULL, 'Poddala', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (840, 0, NULL, 0, NULL, 0, NULL, 'Porawagama', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (841, 0, NULL, 0, NULL, 0, NULL, 'Rantotuwila', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (842, 0, NULL, 0, NULL, 0, NULL, 'Ratgama', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (843, 0, NULL, 0, NULL, 0, NULL, 'Talagampola', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (844, 0, NULL, 0, NULL, 0, NULL, 'Talgaspe', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (845, 0, NULL, 0, NULL, 0, NULL, 'Talgaswela', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (846, 0, NULL, 0, NULL, 0, NULL, 'Talpe', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (847, 0, NULL, 0, NULL, 0, NULL, 'Tawalama', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (848, 0, NULL, 0, NULL, 0, NULL, 'Tiranagama', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (849, 0, NULL, 0, NULL, 0, NULL, 'Udalamatta', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (850, 0, NULL, 0, NULL, 0, NULL, 'Udugama', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (851, 0, NULL, 0, NULL, 0, NULL, 'Uluvitike', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (852, 0, NULL, 0, NULL, 0, NULL, 'Unawatuna', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (853, 0, NULL, 0, NULL, 0, NULL, 'Unenwitiya', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (854, 0, NULL, 0, NULL, 0, NULL, 'Uragaha', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (855, 0, NULL, 0, NULL, 0, NULL, 'Uragasmanhandiya', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (856, 0, NULL, 0, NULL, 0, NULL, 'Wakwella', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (857, 0, NULL, 0, NULL, 0, NULL, 'Walahanduwa', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (858, 0, NULL, 0, NULL, 0, NULL, 'Wanchawela', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (859, 0, NULL, 0, NULL, 0, NULL, 'Wanduramba', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (860, 0, NULL, 0, NULL, 0, NULL, 'Warukandeniya', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (861, 0, NULL, 0, NULL, 0, NULL, 'Watugedara', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (862, 0, NULL, 0, NULL, 0, NULL, 'Weihena', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (863, 0, NULL, 0, NULL, 0, NULL, 'Yakkalamulla', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (864, 0, NULL, 0, NULL, 0, NULL, 'Yatalamatta', 'CI', 'A', 25);
INSERT INTO `geo_area` VALUES (865, 0, NULL, 0, NULL, 0, NULL, 'Akuressa', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (866, 0, NULL, 0, NULL, 0, NULL, 'Alapaladeniya', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (867, 0, NULL, 0, NULL, 0, NULL, 'Aparekka', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (868, 0, NULL, 0, NULL, 0, NULL, 'Athuraliya', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (869, 0, NULL, 0, NULL, 0, NULL, 'Bengamuwa', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (870, 0, NULL, 0, NULL, 0, NULL, 'Beralapanathara', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (871, 0, NULL, 0, NULL, 0, NULL, 'Bopagoda', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (872, 0, NULL, 0, NULL, 0, NULL, 'Dampahala', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (873, 0, NULL, 0, NULL, 0, NULL, 'Deegala Llenama', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (874, 0, NULL, 0, NULL, 0, NULL, 'Deiyandara', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (875, 0, NULL, 0, NULL, 0, NULL, 'Dellawa', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (876, 0, NULL, 0, NULL, 0, NULL, 'Denagama', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (877, 0, NULL, 0, NULL, 0, NULL, 'Denipitiya', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (878, 0, NULL, 0, NULL, 0, NULL, 'Deniyaya', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (879, 0, NULL, 0, NULL, 0, NULL, 'Derangala', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (880, 0, NULL, 0, NULL, 0, NULL, 'Devinuwara (Dondra)', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (881, 0, NULL, 0, NULL, 0, NULL, 'Dikwella', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (882, 0, NULL, 0, NULL, 0, NULL, 'Diyagaha', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (883, 0, NULL, 0, NULL, 0, NULL, 'Diyalape', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (884, 0, NULL, 0, NULL, 0, NULL, 'Gandara', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (885, 0, NULL, 0, NULL, 0, NULL, 'Godapitiya', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (886, 0, NULL, 0, NULL, 0, NULL, 'Gomilamawarala', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (887, 0, NULL, 0, NULL, 0, NULL, 'Hakmana', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (888, 0, NULL, 0, NULL, 0, NULL, 'Handugala', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (889, 0, NULL, 0, NULL, 0, NULL, 'Horapawita', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (890, 0, NULL, 0, NULL, 0, NULL, 'Kalubowitiyana', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (891, 0, NULL, 0, NULL, 0, NULL, 'Kamburugamuwa', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (892, 0, NULL, 0, NULL, 0, NULL, 'Kamburupitiya', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (893, 0, NULL, 0, NULL, 0, NULL, 'Karagoda', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (894, 0, NULL, 0, NULL, 0, NULL, 'Karaputugala', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (895, 0, NULL, 0, NULL, 0, NULL, 'Karatota', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (896, 0, NULL, 0, NULL, 0, NULL, 'Kiriweldola', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (897, 0, NULL, 0, NULL, 0, NULL, 'Kiriwelkele', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (898, 0, NULL, 0, NULL, 0, NULL, 'Kolawenigama', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (899, 0, NULL, 0, NULL, 0, NULL, 'Kotapola', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (900, 0, NULL, 0, NULL, 0, NULL, 'Kottegoda', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (901, 0, NULL, 0, NULL, 0, NULL, 'Lankagama', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (902, 0, NULL, 0, NULL, 0, NULL, 'Makandura', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (903, 0, NULL, 0, NULL, 0, NULL, 'Maliduwa', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (904, 0, NULL, 0, NULL, 0, NULL, 'Maramba', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (905, 0, NULL, 0, NULL, 0, NULL, 'Matara', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (906, 0, NULL, 0, NULL, 0, NULL, 'Mediripitiya', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (907, 0, NULL, 0, NULL, 0, NULL, 'Miella', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (908, 0, NULL, 0, NULL, 0, NULL, 'Mirissa', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (909, 0, NULL, 0, NULL, 0, NULL, 'Moragala Kirillapone', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (910, 0, NULL, 0, NULL, 0, NULL, 'Morawaka', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (911, 0, NULL, 0, NULL, 0, NULL, 'Mulatiyana Junction', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (912, 0, NULL, 0, NULL, 0, NULL, 'Narawelpita', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (913, 0, NULL, 0, NULL, 0, NULL, 'Pahala Millawa', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (914, 0, NULL, 0, NULL, 0, NULL, 'Palatuwa', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (915, 0, NULL, 0, NULL, 0, NULL, 'Paragala', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (916, 0, NULL, 0, NULL, 0, NULL, 'Parapamulla', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (917, 0, NULL, 0, NULL, 0, NULL, 'Pasgoda', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (918, 0, NULL, 0, NULL, 0, NULL, 'Penetiyana', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (919, 0, NULL, 0, NULL, 0, NULL, 'Pitabeddara', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (920, 0, NULL, 0, NULL, 0, NULL, 'Pothdeniya', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (921, 0, NULL, 0, NULL, 0, NULL, 'Puhulwella', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (922, 0, NULL, 0, NULL, 0, NULL, 'Radawela', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (923, 0, NULL, 0, NULL, 0, NULL, 'Ransegoda', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (924, 0, NULL, 0, NULL, 0, NULL, 'Ratmale', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (925, 0, NULL, 0, NULL, 0, NULL, 'Rotumba', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (926, 0, NULL, 0, NULL, 0, NULL, 'Siyambalagoda', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (927, 0, NULL, 0, NULL, 0, NULL, 'Sultanagoda', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (928, 0, NULL, 0, NULL, 0, NULL, 'Telijjawila', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (929, 0, NULL, 0, NULL, 0, NULL, 'Thihagoda', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (930, 0, NULL, 0, NULL, 0, NULL, 'Urubokka', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (931, 0, NULL, 0, NULL, 0, NULL, 'Urugamuwa', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (932, 0, NULL, 0, NULL, 0, NULL, 'Urumutta', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (933, 0, NULL, 0, NULL, 0, NULL, 'Viharahena', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (934, 0, NULL, 0, NULL, 0, NULL, 'Walakanda', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (935, 0, NULL, 0, NULL, 0, NULL, 'Walasgala', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (936, 0, NULL, 0, NULL, 0, NULL, 'Waralla', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (937, 0, NULL, 0, NULL, 0, NULL, 'Wilpita', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (938, 0, NULL, 0, NULL, 0, NULL, 'Yatiyana', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (939, 0, NULL, 0, NULL, 0, NULL, 'Ambalantota', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (940, 0, NULL, 0, NULL, 0, NULL, 'Angunakolapelessa', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (941, 0, NULL, 0, NULL, 0, NULL, 'Bandagiriya Colony', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (942, 0, NULL, 0, NULL, 0, NULL, 'Barawakumbuka', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (943, 0, NULL, 0, NULL, 0, NULL, 'Beliatta', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (944, 0, NULL, 0, NULL, 0, NULL, 'Beragama', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (945, 0, NULL, 0, NULL, 0, NULL, 'Beralihela', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (946, 0, NULL, 0, NULL, 0, NULL, 'Bowalagama', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (947, 0, NULL, 0, NULL, 0, NULL, 'Bundala', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (948, 0, NULL, 0, NULL, 0, NULL, 'Ellagala', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (949, 0, NULL, 0, NULL, 0, NULL, 'Gangulandeniya', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (950, 0, NULL, 0, NULL, 0, NULL, 'Getamanna', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (951, 0, NULL, 0, NULL, 0, NULL, 'Goda Koggalla', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (952, 0, NULL, 0, NULL, 0, NULL, 'GonagamuwaUduwila', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (953, 0, NULL, 0, NULL, 0, NULL, 'Gonnoruwa', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (954, 0, NULL, 0, NULL, 0, NULL, 'Hakuruwela', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (955, 0, NULL, 0, NULL, 0, NULL, 'Hambantota', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (956, 0, NULL, 0, NULL, 0, NULL, 'Horewelagoda', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (957, 0, NULL, 0, NULL, 0, NULL, 'Hungama', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (958, 0, NULL, 0, NULL, 0, NULL, 'Ihala Beligala', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (959, 0, NULL, 0, NULL, 0, NULL, 'Ittademaliya', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (960, 0, NULL, 0, NULL, 0, NULL, 'Julampitiya', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (961, 0, NULL, 0, NULL, 0, NULL, 'Kahandamodara', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (962, 0, NULL, 0, NULL, 0, NULL, 'Kariyamaditta', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (963, 0, NULL, 0, NULL, 0, NULL, 'Katuwana', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (964, 0, NULL, 0, NULL, 0, NULL, 'Kawantissapura', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (965, 0, NULL, 0, NULL, 0, NULL, 'Kirama', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (966, 0, NULL, 0, NULL, 0, NULL, 'Kirinda', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (967, 0, NULL, 0, NULL, 0, NULL, 'Lunama', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (968, 0, NULL, 0, NULL, 0, NULL, 'Lunugamwehera', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (969, 0, NULL, 0, NULL, 0, NULL, 'Magama', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (970, 0, NULL, 0, NULL, 0, NULL, 'Mahadivulwewa', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (971, 0, NULL, 0, NULL, 0, NULL, 'Mahagalwewa', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (972, 0, NULL, 0, NULL, 0, NULL, 'Modarawana', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (973, 0, NULL, 0, NULL, 0, NULL, 'Mulkirigala', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (974, 0, NULL, 0, NULL, 0, NULL, 'Mamadala', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (975, 0, NULL, 0, NULL, 0, NULL, 'Medamulana', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (976, 0, NULL, 0, NULL, 0, NULL, 'Middeniya', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (977, 0, NULL, 0, NULL, 0, NULL, 'Migahajandur', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (978, 0, NULL, 0, NULL, 0, NULL, 'Nakulugamuwa', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (979, 0, NULL, 0, NULL, 0, NULL, 'Netolpitiya', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (980, 0, NULL, 0, NULL, 0, NULL, 'Nihiluwa', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (981, 0, NULL, 0, NULL, 0, NULL, 'Padawkema', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (982, 0, NULL, 0, NULL, 0, NULL, 'Pahala Andarawewa', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (983, 0, NULL, 0, NULL, 0, NULL, 'Pallekanda', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (984, 0, NULL, 0, NULL, 0, NULL, 'Rammalawarapitiya', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (985, 0, NULL, 0, NULL, 0, NULL, 'Ranakeliya', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (986, 0, NULL, 0, NULL, 0, NULL, 'Ranmuduwewa', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (987, 0, NULL, 0, NULL, 0, NULL, 'Ranna', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (988, 0, NULL, 0, NULL, 0, NULL, 'Ratmalwala', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (989, 0, NULL, 0, NULL, 0, NULL, 'RU/Ridiyagama', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (990, 0, NULL, 0, NULL, 0, NULL, 'Sooriyawewa Town', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (991, 0, NULL, 0, NULL, 0, NULL, 'Tangalla', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (992, 0, NULL, 0, NULL, 0, NULL, 'Tissamaharama', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (993, 0, NULL, 0, NULL, 0, NULL, 'Uda Gomadiya', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (994, 0, NULL, 0, NULL, 0, NULL, 'Udamattala', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (995, 0, NULL, 0, NULL, 0, NULL, 'Uswewa', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (996, 0, NULL, 0, NULL, 0, NULL, 'Vitharandeniya', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (997, 0, NULL, 0, NULL, 0, NULL, 'Walasmulla', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (998, 0, NULL, 0, NULL, 0, NULL, 'Weeraketiya', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (999, 0, NULL, 0, NULL, 0, NULL, 'Weerawila', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (1000, 0, NULL, 0, NULL, 0, NULL, 'Weerawila New Town', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (1001, 0, NULL, 0, NULL, 0, NULL, 'Yatigala', 'CI', 'A', 27);
INSERT INTO `geo_area` VALUES (1002, 0, NULL, 0, NULL, 0, NULL, 'Alahengama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1003, 0, NULL, 0, NULL, 0, NULL, 'Alahitiyawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1004, 0, NULL, 0, NULL, 0, NULL, 'Alawatuwala', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1005, 0, NULL, 0, NULL, 0, NULL, 'Alawwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1006, 0, NULL, 0, NULL, 0, NULL, 'Ambakote', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1007, 0, NULL, 0, NULL, 0, NULL, 'Ambanpola', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1008, 0, NULL, 0, NULL, 0, NULL, 'Anhandiya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1009, 0, NULL, 0, NULL, 0, NULL, 'Anukkane', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1010, 0, NULL, 0, NULL, 0, NULL, 'Aragoda', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1011, 0, NULL, 0, NULL, 0, NULL, 'Ataragalla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1012, 0, NULL, 0, NULL, 0, NULL, 'Awulegama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1013, 0, NULL, 0, NULL, 0, NULL, 'Balalla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1014, 0, NULL, 0, NULL, 0, NULL, 'Bamunukotuwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1015, 0, NULL, 0, NULL, 0, NULL, 'Bandara Koswatta', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1016, 0, NULL, 0, NULL, 0, NULL, 'Bingiriya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1017, 0, NULL, 0, NULL, 0, NULL, 'Bogamulla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1018, 0, NULL, 0, NULL, 0, NULL, 'Bopitiya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1019, 0, NULL, 0, NULL, 0, NULL, 'Boraluwewa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1020, 0, NULL, 0, NULL, 0, NULL, 'Boyagane', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1021, 0, NULL, 0, NULL, 0, NULL, 'Bujjomuwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1022, 0, NULL, 0, NULL, 0, NULL, 'Buluwala', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1023, 0, NULL, 0, NULL, 0, NULL, 'Dambadeniya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1024, 0, NULL, 0, NULL, 0, NULL, 'Daraluwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1025, 0, NULL, 0, NULL, 0, NULL, 'Deegalla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1026, 0, NULL, 0, NULL, 0, NULL, 'Delwite', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1027, 0, NULL, 0, NULL, 0, NULL, 'Demataluwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1028, 0, NULL, 0, NULL, 0, NULL, 'Diddeniya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1029, 0, NULL, 0, NULL, 0, NULL, 'Digannewa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1030, 0, NULL, 0, NULL, 0, NULL, 'Divullegoda', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1031, 0, NULL, 0, NULL, 0, NULL, 'Dodangaslanda', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1032, 0, NULL, 0, NULL, 0, NULL, 'Doratiyawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1033, 0, NULL, 0, NULL, 0, NULL, 'Dummalasuriya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1034, 0, NULL, 0, NULL, 0, NULL, 'Ehetuwewa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1035, 0, NULL, 0, NULL, 0, NULL, 'Elibichchiya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1036, 0, NULL, 0, NULL, 0, NULL, 'Embogama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1037, 0, NULL, 0, NULL, 0, NULL, 'Etungahakotuwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1038, 0, NULL, 0, NULL, 0, NULL, 'Galgamuwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1039, 0, NULL, 0, NULL, 0, NULL, 'Gallewa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1040, 0, NULL, 0, NULL, 0, NULL, 'Girathalana', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1041, 0, NULL, 0, NULL, 0, NULL, 'Giriulla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1042, 0, NULL, 0, NULL, 0, NULL, 'Gokaralla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1043, 0, NULL, 0, NULL, 0, NULL, 'Gonawila', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1044, 0, NULL, 0, NULL, 0, NULL, 'Halmillawewa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1045, 0, NULL, 0, NULL, 0, NULL, 'Hengamuwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1046, 0, NULL, 0, NULL, 0, NULL, 'Hettipola', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1047, 0, NULL, 0, NULL, 0, NULL, 'Hilogama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1048, 0, NULL, 0, NULL, 0, NULL, 'Hindagolla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1049, 0, NULL, 0, NULL, 0, NULL, 'Hiriyala Lenawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1050, 0, NULL, 0, NULL, 0, NULL, 'Hiruwalpola', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1051, 0, NULL, 0, NULL, 0, NULL, 'Horambawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1052, 0, NULL, 0, NULL, 0, NULL, 'Hulogedara', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1053, 0, NULL, 0, NULL, 0, NULL, 'Hulugalla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1054, 0, NULL, 0, NULL, 0, NULL, 'Hunupola', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1055, 0, NULL, 0, NULL, 0, NULL, 'Ihala Gomugomuwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1056, 0, NULL, 0, NULL, 0, NULL, 'Ihala Katugampala', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1057, 0, NULL, 0, NULL, 0, NULL, 'Indulgodakanda', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1058, 0, NULL, 0, NULL, 0, NULL, 'Inguruwatta', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1059, 0, NULL, 0, NULL, 0, NULL, 'Iriyagolla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1060, 0, NULL, 0, NULL, 0, NULL, 'Ithanawatta', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1061, 0, NULL, 0, NULL, 0, NULL, 'Kadigawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1062, 0, NULL, 0, NULL, 0, NULL, 'Kahapathwala', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1063, 0, NULL, 0, NULL, 0, NULL, 'Kalugamuwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1064, 0, NULL, 0, NULL, 0, NULL, 'Kanadeniyawala', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1065, 0, NULL, 0, NULL, 0, NULL, 'Kanattewewa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1066, 0, NULL, 0, NULL, 0, NULL, 'Karagahagedara', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1067, 0, NULL, 0, NULL, 0, NULL, 'Karambe', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1068, 0, NULL, 0, NULL, 0, NULL, 'Katupota', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1069, 0, NULL, 0, NULL, 0, NULL, 'Keppitiwalana', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1070, 0, NULL, 0, NULL, 0, NULL, 'Kirimetiyawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1071, 0, NULL, 0, NULL, 0, NULL, 'Kirindawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1072, 0, NULL, 0, NULL, 0, NULL, 'Kithalawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1073, 0, NULL, 0, NULL, 0, NULL, 'Kobeigane', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1074, 0, NULL, 0, NULL, 0, NULL, 'Kohilagedara', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1075, 0, NULL, 0, NULL, 0, NULL, 'Kosdeniya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1076, 0, NULL, 0, NULL, 0, NULL, 'Kosgolla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1077, 0, NULL, 0, NULL, 0, NULL, 'Kotawehera', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1078, 0, NULL, 0, NULL, 0, NULL, 'Kudagalgamuwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1079, 0, NULL, 0, NULL, 0, NULL, 'Kuliyapitiya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1080, 0, NULL, 0, NULL, 0, NULL, 'Kumbukgeta', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1081, 0, NULL, 0, NULL, 0, NULL, 'Kumbukwewa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1082, 0, NULL, 0, NULL, 0, NULL, 'Kuratihena', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1083, 0, NULL, 0, NULL, 0, NULL, 'Labbala', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1084, 0, NULL, 0, NULL, 0, NULL, 'lbbagamuwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1085, 0, NULL, 0, NULL, 0, NULL, 'lhala Kadigamuwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1086, 0, NULL, 0, NULL, 0, NULL, 'llukhena', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1087, 0, NULL, 0, NULL, 0, NULL, 'Lonahettiya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1088, 0, NULL, 0, NULL, 0, NULL, 'Madahapola', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1089, 0, NULL, 0, NULL, 0, NULL, 'Madakumburumulla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1090, 0, NULL, 0, NULL, 0, NULL, 'Maduragoda', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1091, 0, NULL, 0, NULL, 0, NULL, 'Maeliya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1092, 0, NULL, 0, NULL, 0, NULL, 'Magulagama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1093, 0, NULL, 0, NULL, 0, NULL, 'Mahagalkadawala', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1094, 0, NULL, 0, NULL, 0, NULL, 'Mahagirilla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1095, 0, NULL, 0, NULL, 0, NULL, 'Mahamukalanyaya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1096, 0, NULL, 0, NULL, 0, NULL, 'Mahananneriya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1097, 0, NULL, 0, NULL, 0, NULL, 'Maharachchimulla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1098, 0, NULL, 0, NULL, 0, NULL, 'Maho', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1099, 0, NULL, 0, NULL, 0, NULL, 'Makulewa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1100, 0, NULL, 0, NULL, 0, NULL, 'Makulpotha', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1101, 0, NULL, 0, NULL, 0, NULL, 'Makulwewa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1102, 0, NULL, 0, NULL, 0, NULL, 'Malagane', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1103, 0, NULL, 0, NULL, 0, NULL, 'Mandapola', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1104, 0, NULL, 0, NULL, 0, NULL, 'Maspotha', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1105, 0, NULL, 0, NULL, 0, NULL, 'Mawathagama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1106, 0, NULL, 0, NULL, 0, NULL, 'Medivawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1107, 0, NULL, 0, NULL, 0, NULL, 'Meegalawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1108, 0, NULL, 0, NULL, 0, NULL, 'Meetanwala', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1109, 0, NULL, 0, NULL, 0, NULL, 'Meewellawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1110, 0, NULL, 0, NULL, 0, NULL, 'Melsiripura', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1111, 0, NULL, 0, NULL, 0, NULL, 'Metikumbura', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1112, 0, NULL, 0, NULL, 0, NULL, 'Metiyagane', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1113, 0, NULL, 0, NULL, 0, NULL, 'Minuwangete', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1114, 0, NULL, 0, NULL, 0, NULL, 'Mirihanegama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1115, 0, NULL, 0, NULL, 0, NULL, 'Moragane', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1116, 0, NULL, 0, NULL, 0, NULL, 'Morathiha', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1117, 0, NULL, 0, NULL, 0, NULL, 'Nabadewa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1118, 0, NULL, 0, NULL, 0, NULL, 'Nagollagama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1119, 0, NULL, 0, NULL, 0, NULL, 'Nagollagoda', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1120, 0, NULL, 0, NULL, 0, NULL, 'Nakkawatta', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1121, 0, NULL, 0, NULL, 0, NULL, 'Narammala', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1122, 0, NULL, 0, NULL, 0, NULL, 'Narangoda', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1123, 0, NULL, 0, NULL, 0, NULL, 'Nawatalwatta', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1124, 0, NULL, 0, NULL, 0, NULL, 'Nikadalupotha', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1125, 0, NULL, 0, NULL, 0, NULL, 'Nikaweratiya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1126, 0, NULL, 0, NULL, 0, NULL, 'Padeniya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1127, 0, NULL, 0, NULL, 0, NULL, 'Padiwela', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1128, 0, NULL, 0, NULL, 0, NULL, 'Pahalagiribawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1129, 0, NULL, 0, NULL, 0, NULL, 'Pahamune', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1130, 0, NULL, 0, NULL, 0, NULL, 'Palukadawala', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1131, 0, NULL, 0, NULL, 0, NULL, 'Panadaragama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1132, 0, NULL, 0, NULL, 0, NULL, 'Panagamuwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1133, 0, NULL, 0, NULL, 0, NULL, 'Panaliya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1134, 0, NULL, 0, NULL, 0, NULL, 'Panliyadda', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1135, 0, NULL, 0, NULL, 0, NULL, 'Pannala', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1136, 0, NULL, 0, NULL, 0, NULL, 'Pansiyagama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1137, 0, NULL, 0, NULL, 0, NULL, 'Periyakadneluwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1138, 0, NULL, 0, NULL, 0, NULL, 'Pihimbiya Ratmale', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1139, 0, NULL, 0, NULL, 0, NULL, 'Pihimbuwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1140, 0, NULL, 0, NULL, 0, NULL, 'Pilessa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1141, 0, NULL, 0, NULL, 0, NULL, 'Polgahawela', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1142, 0, NULL, 0, NULL, 0, NULL, 'Polpitigama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1143, 0, NULL, 0, NULL, 0, NULL, 'Pothuhera', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1144, 0, NULL, 0, NULL, 0, NULL, 'Puswelitenna', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1145, 0, NULL, 0, NULL, 0, NULL, 'Ridibendiella', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1146, 0, NULL, 0, NULL, 0, NULL, 'Ridigama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1147, 0, NULL, 0, NULL, 0, NULL, 'Saliya Asokapura', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1148, 0, NULL, 0, NULL, 0, NULL, 'Sandalankawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1149, 0, NULL, 0, NULL, 0, NULL, 'Sirisetagama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1150, 0, NULL, 0, NULL, 0, NULL, 'Siyambalangamuwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1151, 0, NULL, 0, NULL, 0, NULL, 'Solepura', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1152, 0, NULL, 0, NULL, 0, NULL, 'Solewewa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1153, 0, NULL, 0, NULL, 0, NULL, 'Sunandapura', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1154, 0, NULL, 0, NULL, 0, NULL, 'Talawattegedara', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1155, 0, NULL, 0, NULL, 0, NULL, 'Tambutta', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1156, 0, NULL, 0, NULL, 0, NULL, 'Thalahitimulla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1157, 0, NULL, 0, NULL, 0, NULL, 'Thalakolawewa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1158, 0, NULL, 0, NULL, 0, NULL, 'Thalwita', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1159, 0, NULL, 0, NULL, 0, NULL, 'Thambagalla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1160, 0, NULL, 0, NULL, 0, NULL, 'Tharana Udawela', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1161, 0, NULL, 0, NULL, 0, NULL, 'Thimbiriyawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1162, 0, NULL, 0, NULL, 0, NULL, 'Tisogama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1163, 0, NULL, 0, NULL, 0, NULL, 'Torayaya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1164, 0, NULL, 0, NULL, 0, NULL, 'Tuttiripitigama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1165, 0, NULL, 0, NULL, 0, NULL, 'Udubaddawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1166, 0, NULL, 0, NULL, 0, NULL, 'Uhumiya', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1167, 0, NULL, 0, NULL, 0, NULL, 'Ulpotha Pallekele', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1168, 0, NULL, 0, NULL, 0, NULL, 'Wadakada', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1169, 0, NULL, 0, NULL, 0, NULL, 'Wadumunnegedara', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1170, 0, NULL, 0, NULL, 0, NULL, 'Walakumburumulla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1171, 0, NULL, 0, NULL, 0, NULL, 'Wannigama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1172, 0, NULL, 0, NULL, 0, NULL, 'Wannikudawewa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1173, 0, NULL, 0, NULL, 0, NULL, 'Wannilhalagama', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1174, 0, NULL, 0, NULL, 0, NULL, 'Wannirasnayakapura', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1175, 0, NULL, 0, NULL, 0, NULL, 'Warawewa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1176, 0, NULL, 0, NULL, 0, NULL, 'Wariyapola', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1177, 0, NULL, 0, NULL, 0, NULL, 'Watuwatta', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1178, 0, NULL, 0, NULL, 0, NULL, 'Weerapokuna', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1179, 0, NULL, 0, NULL, 0, NULL, 'Welawa Junction', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1180, 0, NULL, 0, NULL, 0, NULL, 'Wellagala', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1181, 0, NULL, 0, NULL, 0, NULL, 'Wellarawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1182, 0, NULL, 0, NULL, 0, NULL, 'Wellawa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1183, 0, NULL, 0, NULL, 0, NULL, 'Welpalla', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1184, 0, NULL, 0, NULL, 0, NULL, 'Wennoruwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1185, 0, NULL, 0, NULL, 0, NULL, 'Weuda', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1186, 0, NULL, 0, NULL, 0, NULL, 'Yakwila', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1187, 0, NULL, 0, NULL, 0, NULL, 'Yatigaloluwa', 'CI', 'A', 28);
INSERT INTO `geo_area` VALUES (1188, 0, NULL, 0, NULL, 0, NULL, 'Adippala', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1189, 0, NULL, 0, NULL, 0, NULL, 'Ambakandawila', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1190, 0, NULL, 0, NULL, 0, NULL, 'Anamaduwa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1191, 0, NULL, 0, NULL, 0, NULL, 'Andigama', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1192, 0, NULL, 0, NULL, 0, NULL, 'Angunawila', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1193, 0, NULL, 0, NULL, 0, NULL, 'Attawilluwa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1194, 0, NULL, 0, NULL, 0, NULL, 'Bangadenia', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1195, 0, NULL, 0, NULL, 0, NULL, 'Barankattuwa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1196, 0, NULL, 0, NULL, 0, NULL, 'Battuluoya', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1197, 0, NULL, 0, NULL, 0, NULL, 'Bujjampola', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1198, 0, NULL, 0, NULL, 0, NULL, 'Chilaw', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1199, 0, NULL, 0, NULL, 0, NULL, 'Dankotuwa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1200, 0, NULL, 0, NULL, 0, NULL, 'Eluwankulama', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1201, 0, NULL, 0, NULL, 0, NULL, 'Ettale', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1202, 0, NULL, 0, NULL, 0, NULL, 'Galmuruwa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1203, 0, NULL, 0, NULL, 0, NULL, 'Ihala Kottaramulla', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1204, 0, NULL, 0, NULL, 0, NULL, 'lhala Puliyankulama', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1205, 0, NULL, 0, NULL, 0, NULL, 'Ilippadenia', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1206, 0, NULL, 0, NULL, 0, NULL, 'Ismailpuram', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1207, 0, NULL, 0, NULL, 0, NULL, 'Kakkappalli', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1208, 0, NULL, 0, NULL, 0, NULL, 'Kalladiya', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1209, 0, NULL, 0, NULL, 0, NULL, 'Kalpitiya', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1210, 0, NULL, 0, NULL, 0, NULL, 'Kandakuliya', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1211, 0, NULL, 0, NULL, 0, NULL, 'Karawitagara', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1212, 0, NULL, 0, NULL, 0, NULL, 'Karuwalagaswewa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1213, 0, NULL, 0, NULL, 0, NULL, 'Katuneriya', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1214, 0, NULL, 0, NULL, 0, NULL, 'Koswatta', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1215, 0, NULL, 0, NULL, 0, NULL, 'Kottantivu', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1216, 0, NULL, 0, NULL, 0, NULL, 'Kottukachchiya', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1217, 0, NULL, 0, NULL, 0, NULL, 'Kudawewa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1218, 0, NULL, 0, NULL, 0, NULL, 'Kumarakattuwa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1219, 0, NULL, 0, NULL, 0, NULL, 'Kurinjanpitiya', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1220, 0, NULL, 0, NULL, 0, NULL, 'Kuruketiyawa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1221, 0, NULL, 0, NULL, 0, NULL, 'Lihiriyagama', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1222, 0, NULL, 0, NULL, 0, NULL, 'Lunuwila', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1223, 0, NULL, 0, NULL, 0, NULL, 'Madampe', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1224, 0, NULL, 0, NULL, 0, NULL, 'Madurankuliya', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1225, 0, NULL, 0, NULL, 0, NULL, 'Mahakumbukkadawala', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1226, 0, NULL, 0, NULL, 0, NULL, 'Mahauswewa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1227, 0, NULL, 0, NULL, 0, NULL, 'Mahawewa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1228, 0, NULL, 0, NULL, 0, NULL, 'Mampuri', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1229, 0, NULL, 0, NULL, 0, NULL, 'Mangalaeliya', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1230, 0, NULL, 0, NULL, 0, NULL, 'Marawila', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1231, 0, NULL, 0, NULL, 0, NULL, 'Mudalakkuliya', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1232, 0, NULL, 0, NULL, 0, NULL, 'Mugunuwatawana', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1233, 0, NULL, 0, NULL, 0, NULL, 'Mukkutoduwawa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1234, 0, NULL, 0, NULL, 0, NULL, 'Muttibendiwila', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1235, 0, NULL, 0, NULL, 0, NULL, 'Nainamadama', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1236, 0, NULL, 0, NULL, 0, NULL, 'Nalladarankattuwa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1237, 0, NULL, 0, NULL, 0, NULL, 'Nattandiya', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1238, 0, NULL, 0, NULL, 0, NULL, 'Nawagattegama', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1239, 0, NULL, 0, NULL, 0, NULL, 'Norachcholai', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1240, 0, NULL, 0, NULL, 0, NULL, 'Palaviya', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1241, 0, NULL, 0, NULL, 0, NULL, 'Palliwasalturai', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1242, 0, NULL, 0, NULL, 0, NULL, 'Panirendawa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1243, 0, NULL, 0, NULL, 0, NULL, 'Pallama', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1244, 0, NULL, 0, NULL, 0, NULL, 'Pothuwatawana', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1245, 0, NULL, 0, NULL, 0, NULL, 'Puttalam', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1246, 0, NULL, 0, NULL, 0, NULL, 'PuttalamCementFactory', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1247, 0, NULL, 0, NULL, 0, NULL, 'Rajakadaluwa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1248, 0, NULL, 0, NULL, 0, NULL, 'Saliya wewa Junction', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1249, 0, NULL, 0, NULL, 0, NULL, 'Serukele', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1250, 0, NULL, 0, NULL, 0, NULL, 'Sirambiadia', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1251, 0, NULL, 0, NULL, 0, NULL, 'Siambalagashene', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1252, 0, NULL, 0, NULL, 0, NULL, 'Tabbowa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1253, 0, NULL, 0, NULL, 0, NULL, 'Talawila Church', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1254, 0, NULL, 0, NULL, 0, NULL, 'Toduwa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1255, 0, NULL, 0, NULL, 0, NULL, 'Udappu', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1256, 0, NULL, 0, NULL, 0, NULL, 'Uridiyava', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1257, 0, NULL, 0, NULL, 0, NULL, 'Vanathawilluwa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1258, 0, NULL, 0, NULL, 0, NULL, 'Waikkal', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1259, 0, NULL, 0, NULL, 0, NULL, 'Watugahamulla', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1260, 0, NULL, 0, NULL, 0, NULL, 'Wennappuwa', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1261, 0, NULL, 0, NULL, 0, NULL, 'Wijeyakatupotha', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1262, 0, NULL, 0, NULL, 0, NULL, 'Wilpotha', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1263, 0, NULL, 0, NULL, 0, NULL, 'Yogiyana', 'CI', 'A', 29);
INSERT INTO `geo_area` VALUES (1264, 0, NULL, 0, NULL, 0, NULL, 'Andiyagala', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1265, 0, NULL, 0, NULL, 0, NULL, 'Awukana', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1266, 0, NULL, 0, NULL, 0, NULL, 'Anuradhapura', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1267, 0, NULL, 0, NULL, 0, NULL, 'Bohawewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1268, 0, NULL, 0, NULL, 0, NULL, 'Dematawewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1269, 0, NULL, 0, NULL, 0, NULL, 'Dunumadalawa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1270, 0, NULL, 0, NULL, 0, NULL, 'Dutuwewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1271, 0, NULL, 0, NULL, 0, NULL, 'Elayapattuwa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1272, 0, NULL, 0, NULL, 0, NULL, 'Eppawala', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1273, 0, NULL, 0, NULL, 0, NULL, 'Etawatunuwewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1274, 0, NULL, 0, NULL, 0, NULL, 'Etaweeragollewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1275, 0, NULL, 0, NULL, 0, NULL, 'Galadivulwewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1276, 0, NULL, 0, NULL, 0, NULL, 'Galenbindunuwewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1277, 0, NULL, 0, NULL, 0, NULL, 'Galkadawala', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1278, 0, NULL, 0, NULL, 0, NULL, 'Galkiriyagama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1279, 0, NULL, 0, NULL, 0, NULL, 'Galkulama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1280, 0, NULL, 0, NULL, 0, NULL, 'Galnewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1281, 0, NULL, 0, NULL, 0, NULL, 'Gambirigaswewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1282, 0, NULL, 0, NULL, 0, NULL, 'Ganewalpola', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1283, 0, NULL, 0, NULL, 0, NULL, 'Gemunupura', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1284, 0, NULL, 0, NULL, 0, NULL, 'Getalawa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1285, 0, NULL, 0, NULL, 0, NULL, 'Gnanikulama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1286, 0, NULL, 0, NULL, 0, NULL, 'Gonahaddenawa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1287, 0, NULL, 0, NULL, 0, NULL, 'Habarana', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1288, 0, NULL, 0, NULL, 0, NULL, 'Halmillawa Dambulla', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1289, 0, NULL, 0, NULL, 0, NULL, 'Halmillawetiya', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1290, 0, NULL, 0, NULL, 0, NULL, 'Hidogama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1291, 0, NULL, 0, NULL, 0, NULL, 'Horawpatana', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1292, 0, NULL, 0, NULL, 0, NULL, 'Horivila', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1293, 0, NULL, 0, NULL, 0, NULL, 'Hurigaswewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1294, 0, NULL, 0, NULL, 0, NULL, 'Kahatagollewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1295, 0, NULL, 0, NULL, 0, NULL, 'Kagama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1296, 0, NULL, 0, NULL, 0, NULL, 'Kahatagasdigilia', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1297, 0, NULL, 0, NULL, 0, NULL, 'Katiyawa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1298, 0, NULL, 0, NULL, 0, NULL, 'Kalakarambewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1299, 0, NULL, 0, NULL, 0, NULL, 'Kalankuttia', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1300, 0, NULL, 0, NULL, 0, NULL, 'Kalaoya', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1301, 0, NULL, 0, NULL, 0, NULL, 'Kalawedi Ulpotha', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1302, 0, NULL, 0, NULL, 0, NULL, 'Kallanchiya', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1303, 0, NULL, 0, NULL, 0, NULL, 'Capugallawa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1304, 0, NULL, 0, NULL, 0, NULL, 'Karagahawewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1305, 0, NULL, 0, NULL, 0, NULL, 'Kebithigollewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1306, 0, NULL, 0, NULL, 0, NULL, 'Kekirawa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1307, 0, NULL, 0, NULL, 0, NULL, 'Kendewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1308, 0, NULL, 0, NULL, 0, NULL, 'Kiralogama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1309, 0, NULL, 0, NULL, 0, NULL, 'Kitulhitiyawa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1310, 0, NULL, 0, NULL, 0, NULL, 'Kurundankulama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1311, 0, NULL, 0, NULL, 0, NULL, 'Labunoruwa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1312, 0, NULL, 0, NULL, 0, NULL, 'Halmillewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1313, 0, NULL, 0, NULL, 0, NULL, 'lhalagama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1314, 0, NULL, 0, NULL, 0, NULL, 'lplogama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1315, 0, NULL, 0, NULL, 0, NULL, 'Madatugama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1316, 0, NULL, 0, NULL, 0, NULL, 'Maha Elagamuwa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1317, 0, NULL, 0, NULL, 0, NULL, 'Mahabulankulama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1318, 0, NULL, 0, NULL, 0, NULL, 'Mahailluppallama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1319, 0, NULL, 0, NULL, 0, NULL, 'Mahakanadarawa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1320, 0, NULL, 0, NULL, 0, NULL, 'Mahapothana', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1321, 0, NULL, 0, NULL, 0, NULL, 'Mahasenpura', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1322, 0, NULL, 0, NULL, 0, NULL, 'Mahawilachchiya', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1323, 0, NULL, 0, NULL, 0, NULL, 'Mailagaswewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1324, 0, NULL, 0, NULL, 0, NULL, 'Malwanagama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1325, 0, NULL, 0, NULL, 0, NULL, 'Maneruwa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1326, 0, NULL, 0, NULL, 0, NULL, 'Maradankadawala', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1327, 0, NULL, 0, NULL, 0, NULL, 'Maradankalla', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1328, 0, NULL, 0, NULL, 0, NULL, 'Medawachchiya', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1329, 0, NULL, 0, NULL, 0, NULL, 'Megodawewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1330, 0, NULL, 0, NULL, 0, NULL, 'Mihintale', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1331, 0, NULL, 0, NULL, 0, NULL, 'Morakewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1332, 0, NULL, 0, NULL, 0, NULL, 'Muriyakadawala', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1333, 0, NULL, 0, NULL, 0, NULL, 'Nachchaduwa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1334, 0, NULL, 0, NULL, 0, NULL, 'Namalpura', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1335, 0, NULL, 0, NULL, 0, NULL, 'Negampaha', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1336, 0, NULL, 0, NULL, 0, NULL, 'Nochchiyagama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1337, 0, NULL, 0, NULL, 0, NULL, 'Padavi Maithripura', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1338, 0, NULL, 0, NULL, 0, NULL, 'Padavi arakramapura', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1339, 0, NULL, 0, NULL, 0, NULL, 'Padavi Sripura', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1340, 0, NULL, 0, NULL, 0, NULL, 'Padavi Sritissapura', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1341, 0, NULL, 0, NULL, 0, NULL, 'Padaviya', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1342, 0, NULL, 0, NULL, 0, NULL, 'Padikaramaduwa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1343, 0, NULL, 0, NULL, 0, NULL, 'Pahala Halmillewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1344, 0, NULL, 0, NULL, 0, NULL, 'Pahala Maragahawe', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1345, 0, NULL, 0, NULL, 0, NULL, 'Pahalagama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1346, 0, NULL, 0, NULL, 0, NULL, 'Palagala', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1347, 0, NULL, 0, NULL, 0, NULL, 'Palugaswewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1348, 0, NULL, 0, NULL, 0, NULL, 'Pandukabayapura', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1349, 0, NULL, 0, NULL, 0, NULL, 'Pandulagama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1350, 0, NULL, 0, NULL, 0, NULL, 'Parakumpura', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1351, 0, NULL, 0, NULL, 0, NULL, 'Parangiyawadiya', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1352, 0, NULL, 0, NULL, 0, NULL, 'Parasangahawewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1353, 0, NULL, 0, NULL, 0, NULL, 'Pemaduwa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1354, 0, NULL, 0, NULL, 0, NULL, 'Perimiyankulama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1355, 0, NULL, 0, NULL, 0, NULL, 'Pihimbiagolewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1356, 0, NULL, 0, NULL, 0, NULL, 'Pubbogama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1357, 0, NULL, 0, NULL, 0, NULL, 'Pulmoddai', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1358, 0, NULL, 0, NULL, 0, NULL, 'Rajanganaya', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1359, 0, NULL, 0, NULL, 0, NULL, 'Rambewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1360, 0, NULL, 0, NULL, 0, NULL, 'Rampathwila', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1361, 0, NULL, 0, NULL, 0, NULL, 'Ranorawa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1362, 0, NULL, 0, NULL, 0, NULL, 'Rathmalgahawewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1363, 0, NULL, 0, NULL, 0, NULL, 'Saliyapura', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1364, 0, NULL, 0, NULL, 0, NULL, 'Seeppukulam', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1365, 0, NULL, 0, NULL, 0, NULL, 'Senapura', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1366, 0, NULL, 0, NULL, 0, NULL, 'Sivalakulam', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1367, 0, NULL, 0, NULL, 0, NULL, 'Siyambalewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1368, 0, NULL, 0, NULL, 0, NULL, 'Sravasthipura', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1369, 0, NULL, 0, NULL, 0, NULL, 'Tala', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1370, 0, NULL, 0, NULL, 0, NULL, 'Tambuttegama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1371, 0, NULL, 0, NULL, 0, NULL, 'Tantrimale', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1372, 0, NULL, 0, NULL, 0, NULL, 'Telehiriya', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1373, 0, NULL, 0, NULL, 0, NULL, 'Tirappane', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1374, 0, NULL, 0, NULL, 0, NULL, 'Tittagonewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1375, 0, NULL, 0, NULL, 0, NULL, 'Udunuwara Colony', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1376, 0, NULL, 0, NULL, 0, NULL, 'Upuldeniya', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1377, 0, NULL, 0, NULL, 0, NULL, 'Uttimaduwa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1378, 0, NULL, 0, NULL, 0, NULL, 'Viharapalugama', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1379, 0, NULL, 0, NULL, 0, NULL, 'Vijithapura', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1380, 0, NULL, 0, NULL, 0, NULL, 'Wahamalgollewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1381, 0, NULL, 0, NULL, 0, NULL, 'Walahawiddawewa', 'CI', 'A', 30);
INSERT INTO `geo_area` VALUES (1382, 0, NULL, 0, NULL, 0, NULL, 'Alutwewa', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1383, 0, NULL, 0, NULL, 0, NULL, 'Aralaganwila', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1384, 0, NULL, 0, NULL, 0, NULL, 'Aselapura', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1385, 0, NULL, 0, NULL, 0, NULL, 'Attanakadawala', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1386, 0, NULL, 0, NULL, 0, NULL, 'Bakamuna', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1387, 0, NULL, 0, NULL, 0, NULL, 'Dalukana', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1388, 0, NULL, 0, NULL, 0, NULL, 'Damminna', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1389, 0, NULL, 0, NULL, 0, NULL, 'Dewagala', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1390, 0, NULL, 0, NULL, 0, NULL, 'Dimbulagala', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1391, 0, NULL, 0, NULL, 0, NULL, 'Divulankadawala', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1392, 0, NULL, 0, NULL, 0, NULL, 'Divuldamana', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1393, 0, NULL, 0, NULL, 0, NULL, 'Diyabeduma', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1394, 0, NULL, 0, NULL, 0, NULL, 'Diyasenpura', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1395, 0, NULL, 0, NULL, 0, NULL, 'Elahera', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1396, 0, NULL, 0, NULL, 0, NULL, 'Ellewewa', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1397, 0, NULL, 0, NULL, 0, NULL, 'Galamuna', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1398, 0, NULL, 0, NULL, 0, NULL, 'Galoya Junction', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1399, 0, NULL, 0, NULL, 0, NULL, 'Giritale', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1400, 0, NULL, 0, NULL, 0, NULL, 'Hansayapalama', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1401, 0, NULL, 0, NULL, 0, NULL, 'Hingurakdamana', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1402, 0, NULL, 0, NULL, 0, NULL, 'Hingurakgoda', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1403, 0, NULL, 0, NULL, 0, NULL, 'Jayanthipura', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1404, 0, NULL, 0, NULL, 0, NULL, 'Jayasiripura', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1405, 0, NULL, 0, NULL, 0, NULL, 'Kalingaela', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1406, 0, NULL, 0, NULL, 0, NULL, 'Kalukele Badanagala', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1407, 0, NULL, 0, NULL, 0, NULL, 'Kashyapapura', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1408, 0, NULL, 0, NULL, 0, NULL, 'Kawudulla', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1409, 0, NULL, 0, NULL, 0, NULL, 'Kawuduluwewa Stagell', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1410, 0, NULL, 0, NULL, 0, NULL, 'Kottapitiya', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1411, 0, NULL, 0, NULL, 0, NULL, 'Kumaragama', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1412, 0, NULL, 0, NULL, 0, NULL, 'Lakshauyana', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1413, 0, NULL, 0, NULL, 0, NULL, 'Maduruoya', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1414, 0, NULL, 0, NULL, 0, NULL, 'MahaAmbagaswewa', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1415, 0, NULL, 0, NULL, 0, NULL, 'Mahatalakolawewa', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1416, 0, NULL, 0, NULL, 0, NULL, 'Mahawela Sinhapura', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1417, 0, NULL, 0, NULL, 0, NULL, 'Mampitiya', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1418, 0, NULL, 0, NULL, 0, NULL, 'Medirigiriya', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1419, 0, NULL, 0, NULL, 0, NULL, 'Meegaswewa', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1420, 0, NULL, 0, NULL, 0, NULL, 'Minneriya', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1421, 0, NULL, 0, NULL, 0, NULL, 'Nelumwewa', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1422, 0, NULL, 0, NULL, 0, NULL, 'Nuwaragala', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1423, 0, NULL, 0, NULL, 0, NULL, 'Orubendi Siyambalawa', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1424, 0, NULL, 0, NULL, 0, NULL, 'Onegama', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1425, 0, NULL, 0, NULL, 0, NULL, 'Palugasdamana', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1426, 0, NULL, 0, NULL, 0, NULL, 'Parakramasamudraya', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1427, 0, NULL, 0, NULL, 0, NULL, 'Pelatiyawa', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1428, 0, NULL, 0, NULL, 0, NULL, 'Pimburattewa', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1429, 0, NULL, 0, NULL, 0, NULL, 'Polonnaruwa', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1430, 0, NULL, 0, NULL, 0, NULL, 'Pulastigama', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1431, 0, NULL, 0, NULL, 0, NULL, 'Sevanapitiya', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1432, 0, NULL, 0, NULL, 0, NULL, 'Sinhagama', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1433, 0, NULL, 0, NULL, 0, NULL, 'Sungavila', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1434, 0, NULL, 0, NULL, 0, NULL, 'Talpotha', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1435, 0, NULL, 0, NULL, 0, NULL, 'Tamankaduwa', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1436, 0, NULL, 0, NULL, 0, NULL, 'Tambala', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1437, 0, NULL, 0, NULL, 0, NULL, 'Unagalavehera', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1438, 0, NULL, 0, NULL, 0, NULL, 'Welikanda', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1439, 0, NULL, 0, NULL, 0, NULL, 'Yodaela', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1440, 0, NULL, 0, NULL, 0, NULL, 'Yudaganawa', 'CI', 'A', 31);
INSERT INTO `geo_area` VALUES (1441, 0, NULL, 0, NULL, 0, NULL, 'Akkarasiy', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1442, 0, NULL, 0, NULL, 0, NULL, 'Aluketiyaw', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1443, 0, NULL, 0, NULL, 0, NULL, 'Aluttaramma', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1444, 0, NULL, 0, NULL, 0, NULL, 'Ambadandegama', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1445, 0, NULL, 0, NULL, 0, NULL, 'Ambagahawatta', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1446, 0, NULL, 0, NULL, 0, NULL, 'Ambagasdowa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1447, 0, NULL, 0, NULL, 0, NULL, 'Amunumulla', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1448, 0, NULL, 0, NULL, 0, NULL, 'Arawa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1449, 0, NULL, 0, NULL, 0, NULL, 'Arawakumbura', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1450, 0, NULL, 0, NULL, 0, NULL, 'Arawatta', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1451, 0, NULL, 0, NULL, 0, NULL, 'Atakiriya', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1452, 0, NULL, 0, NULL, 0, NULL, 'Badulla', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1453, 0, NULL, 0, NULL, 0, NULL, 'Baduluoya', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1454, 0, NULL, 0, NULL, 0, NULL, 'Ballaketuwa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1455, 0, NULL, 0, NULL, 0, NULL, 'Bambarapana', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1456, 0, NULL, 0, NULL, 0, NULL, 'Bandarawela', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1457, 0, NULL, 0, NULL, 0, NULL, 'Beramada', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1458, 0, NULL, 0, NULL, 0, NULL, 'Bibilegama', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1459, 0, NULL, 0, NULL, 0, NULL, 'Bogahakumbura', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1460, 0, NULL, 0, NULL, 0, NULL, 'Boragas', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1461, 0, NULL, 0, NULL, 0, NULL, 'Boralanda', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1462, 0, NULL, 0, NULL, 0, NULL, 'Bowela', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1463, 0, NULL, 0, NULL, 0, NULL, 'Dambana', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1464, 0, NULL, 0, NULL, 0, NULL, 'Demodara', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1465, 0, NULL, 0, NULL, 0, NULL, 'Diganatenna', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1466, 0, NULL, 0, NULL, 0, NULL, 'Dikkapitiya', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1467, 0, NULL, 0, NULL, 0, NULL, 'Dimbulana', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1468, 0, NULL, 0, NULL, 0, NULL, 'Divulapelessa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1469, 0, NULL, 0, NULL, 0, NULL, 'Diyatalawa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1470, 0, NULL, 0, NULL, 0, NULL, 'Dulgolla', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1471, 0, NULL, 0, NULL, 0, NULL, 'Egodawela', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1472, 0, NULL, 0, NULL, 0, NULL, 'Ella', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1473, 0, NULL, 0, NULL, 0, NULL, 'Ettampitiya', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1474, 0, NULL, 0, NULL, 0, NULL, 'Galauda', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1475, 0, NULL, 0, NULL, 0, NULL, 'Galedanda', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1476, 0, NULL, 0, NULL, 0, NULL, 'Galporuyaya', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1477, 0, NULL, 0, NULL, 0, NULL, 'Gamewela', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1478, 0, NULL, 0, NULL, 0, NULL, 'Gawarawela', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1479, 0, NULL, 0, NULL, 0, NULL, 'Girandurukotte', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1480, 0, NULL, 0, NULL, 0, NULL, 'Godunna', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1481, 0, NULL, 0, NULL, 0, NULL, 'Gurutalawa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1482, 0, NULL, 0, NULL, 0, NULL, 'Haldummulla', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1483, 0, NULL, 0, NULL, 0, NULL, 'Hali Ela', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1484, 0, NULL, 0, NULL, 0, NULL, 'Hangunnawa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1485, 0, NULL, 0, NULL, 0, NULL, 'Haputale', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1486, 0, NULL, 0, NULL, 0, NULL, 'Hebarawa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1487, 0, NULL, 0, NULL, 0, NULL, 'Heeloya', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1488, 0, NULL, 0, NULL, 0, NULL, 'Helahalpe', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1489, 0, NULL, 0, NULL, 0, NULL, 'Helapupula', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1490, 0, NULL, 0, NULL, 0, NULL, 'Hewanakumbura', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1491, 0, NULL, 0, NULL, 0, NULL, 'Hingurukaduwa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1492, 0, NULL, 0, NULL, 0, NULL, 'Hopton', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1493, 0, NULL, 0, NULL, 0, NULL, 'Idalgashinna', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1494, 0, NULL, 0, NULL, 0, NULL, 'Jangulla', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1495, 0, NULL, 0, NULL, 0, NULL, 'Kahataruppa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1496, 0, NULL, 0, NULL, 0, NULL, 'Kalubululanda', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1497, 0, NULL, 0, NULL, 0, NULL, 'Kalugahakandura', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1498, 0, NULL, 0, NULL, 0, NULL, 'Kalupahana', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1499, 0, NULL, 0, NULL, 0, NULL, 'Kandaketya', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1500, 0, NULL, 0, NULL, 0, NULL, 'Kandegedara', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1501, 0, NULL, 0, NULL, 0, NULL, 'Kandepuhulpola', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1502, 0, NULL, 0, NULL, 0, NULL, 'Keselpotha', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1503, 0, NULL, 0, NULL, 0, NULL, 'Koslanda', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1504, 0, NULL, 0, NULL, 0, NULL, 'Kotamuduna', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1505, 0, NULL, 0, NULL, 0, NULL, 'Kuruwitenna', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1506, 0, NULL, 0, NULL, 0, NULL, 'Kuttiyagolla', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1507, 0, NULL, 0, NULL, 0, NULL, 'Landewela', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1508, 0, NULL, 0, NULL, 0, NULL, 'Liyangahawela', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1509, 0, NULL, 0, NULL, 0, NULL, 'Lunugala', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1510, 0, NULL, 0, NULL, 0, NULL, 'Lunuwatta', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1511, 0, NULL, 0, NULL, 0, NULL, 'Madulsima', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1512, 0, NULL, 0, NULL, 0, NULL, 'Mahiyanganaya', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1513, 0, NULL, 0, NULL, 0, NULL, 'Makulella', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1514, 0, NULL, 0, NULL, 0, NULL, 'Malgoda', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1515, 0, NULL, 0, NULL, 0, NULL, 'Maliyadda', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1516, 0, NULL, 0, NULL, 0, NULL, 'Mapakadawewa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1517, 0, NULL, 0, NULL, 0, NULL, 'Maspanna', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1518, 0, NULL, 0, NULL, 0, NULL, 'Maussagolla', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1519, 0, NULL, 0, NULL, 0, NULL, 'Medawela Udukinda', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1520, 0, NULL, 0, NULL, 0, NULL, 'Medawelagama', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1521, 0, NULL, 0, NULL, 0, NULL, 'Meegahakiula', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1522, 0, NULL, 0, NULL, 0, NULL, 'Metigahatenna', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1523, 0, NULL, 0, NULL, 0, NULL, 'Matigahatenna', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1524, 0, NULL, 0, NULL, 0, NULL, 'Mirahawatta', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1525, 0, NULL, 0, NULL, 0, NULL, 'Miyanakandura', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1526, 0, NULL, 0, NULL, 0, NULL, 'Namunukula', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1527, 0, NULL, 0, NULL, 0, NULL, 'Narangala', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1528, 0, NULL, 0, NULL, 0, NULL, 'Nelumgama', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1529, 0, NULL, 0, NULL, 0, NULL, 'Nikapotha', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1530, 0, NULL, 0, NULL, 0, NULL, 'Nugatalawa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1531, 0, NULL, 0, NULL, 0, NULL, 'Ohiya', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1532, 0, NULL, 0, NULL, 0, NULL, 'Pahalarathkinda', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1533, 0, NULL, 0, NULL, 0, NULL, 'Pallekiruwa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1534, 0, NULL, 0, NULL, 0, NULL, 'Passara', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1535, 0, NULL, 0, NULL, 0, NULL, 'Pathanewatta', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1536, 0, NULL, 0, NULL, 0, NULL, 'Pattiyagedara', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1537, 0, NULL, 0, NULL, 0, NULL, 'Pelagahatenna', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1538, 0, NULL, 0, NULL, 0, NULL, 'Perawella', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1539, 0, NULL, 0, NULL, 0, NULL, 'Pitamaruwa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1540, 0, NULL, 0, NULL, 0, NULL, 'Pitapola', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1541, 0, NULL, 0, NULL, 0, NULL, 'Puhulpola', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1542, 0, NULL, 0, NULL, 0, NULL, 'Ratkarawwa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1543, 0, NULL, 0, NULL, 0, NULL, 'Ridimaliyadda', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1544, 0, NULL, 0, NULL, 0, NULL, 'Rilpola', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1545, 0, NULL, 0, NULL, 0, NULL, 'Silmiyapura', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1546, 0, NULL, 0, NULL, 0, NULL, 'Sirimalgoda', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1547, 0, NULL, 0, NULL, 0, NULL, 'Sorabora Colony', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1548, 0, NULL, 0, NULL, 0, NULL, 'Soragune', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1549, 0, NULL, 0, NULL, 0, NULL, 'Soranatota', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1550, 0, NULL, 0, NULL, 0, NULL, 'Spring Valley', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1551, 0, NULL, 0, NULL, 0, NULL, 'Taldena', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1552, 0, NULL, 0, NULL, 0, NULL, 'Tennepanguwa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1553, 0, NULL, 0, NULL, 0, NULL, 'Timbirigaspitiya', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1554, 0, NULL, 0, NULL, 0, NULL, 'Uduhawara', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1555, 0, NULL, 0, NULL, 0, NULL, 'Uraniya', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1556, 0, NULL, 0, NULL, 0, NULL, 'Uva Deegalla', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1557, 0, NULL, 0, NULL, 0, NULL, 'Uva Karandagolla', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1558, 0, NULL, 0, NULL, 0, NULL, 'Uva Mawelagama', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1559, 0, NULL, 0, NULL, 0, NULL, 'Uva Tenna', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1560, 0, NULL, 0, NULL, 0, NULL, 'Uva Tissapura', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1561, 0, NULL, 0, NULL, 0, NULL, 'Uva Uduwara', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1562, 0, NULL, 0, NULL, 0, NULL, 'Uvaparanagama', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1563, 0, NULL, 0, NULL, 0, NULL, 'Welimada', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1564, 0, NULL, 0, NULL, 0, NULL, 'Wewatta', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1565, 0, NULL, 0, NULL, 0, NULL, 'Wineethagama', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1566, 0, NULL, 0, NULL, 0, NULL, 'Yalagamuwn', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1567, 0, NULL, 0, NULL, 0, NULL, 'Yalagamuwa', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1568, 0, NULL, 0, NULL, 0, NULL, 'Yalwela', 'CI', 'A', 32);
INSERT INTO `geo_area` VALUES (1569, 0, NULL, 0, NULL, 0, NULL, 'Angunakolawewa', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1570, 0, NULL, 0, NULL, 0, NULL, 'Ayiwela', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1571, 0, NULL, 0, NULL, 0, NULL, 'Badalkumbura', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1572, 0, NULL, 0, NULL, 0, NULL, 'Baduluwela', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1573, 0, NULL, 0, NULL, 0, NULL, 'Bakinigahawela', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1574, 0, NULL, 0, NULL, 0, NULL, 'Balaharuwa', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1575, 0, NULL, 0, NULL, 0, NULL, 'Bibile', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1576, 0, NULL, 0, NULL, 0, NULL, 'Buddama', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1577, 0, NULL, 0, NULL, 0, NULL, 'Buttala', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1578, 0, NULL, 0, NULL, 0, NULL, 'Dambagalla', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1579, 0, NULL, 0, NULL, 0, NULL, 'Diyakobala', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1580, 0, NULL, 0, NULL, 0, NULL, 'Dombagahawela', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1581, 0, NULL, 0, NULL, 0, NULL, 'Ekamutugama', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1582, 0, NULL, 0, NULL, 0, NULL, 'Ekiriyankumbura', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1583, 0, NULL, 0, NULL, 0, NULL, 'Ethimalewewa', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1584, 0, NULL, 0, NULL, 0, NULL, 'Ettiliwewa', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1585, 0, NULL, 0, NULL, 0, NULL, 'Galabedda', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1586, 0, NULL, 0, NULL, 0, NULL, 'Hambegamuwa', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1587, 0, NULL, 0, NULL, 0, NULL, 'Hulandawa', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1588, 0, NULL, 0, NULL, 0, NULL, 'Inginiyagala', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1589, 0, NULL, 0, NULL, 0, NULL, 'Kandaudapanguwa', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1590, 0, NULL, 0, NULL, 0, NULL, 'Kandawinna', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1591, 0, NULL, 0, NULL, 0, NULL, 'Mahagama Colony', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1592, 0, NULL, 0, NULL, 0, NULL, 'Marawa', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1593, 0, NULL, 0, NULL, 0, NULL, 'Mariarawa', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1594, 0, NULL, 0, NULL, 0, NULL, 'Medagana', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1595, 0, NULL, 0, NULL, 0, NULL, 'Nakkala', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1596, 0, NULL, 0, NULL, 0, NULL, 'Nannapurawa', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1597, 0, NULL, 0, NULL, 0, NULL, 'Obbegoda', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1598, 0, NULL, 0, NULL, 0, NULL, 'Okkampitiya', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1599, 0, NULL, 0, NULL, 0, NULL, 'Pangura', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1600, 0, NULL, 0, NULL, 0, NULL, 'Pitakumbura', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1601, 0, NULL, 0, NULL, 0, NULL, 'Randeniya', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1602, 0, NULL, 0, NULL, 0, NULL, 'Ruwalwela', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1603, 0, NULL, 0, NULL, 0, NULL, 'Sella Kataragama', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1604, 0, NULL, 0, NULL, 0, NULL, 'Sewanagala', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1605, 0, NULL, 0, NULL, 0, NULL, 'Siyambalagune', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1606, 0, NULL, 0, NULL, 0, NULL, 'Siyabmalangamuwa', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1607, 0, NULL, 0, NULL, 0, NULL, 'Siyambalanduwa', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1608, 0, NULL, 0, NULL, 0, NULL, 'Suriara', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1609, 0, NULL, 0, NULL, 0, NULL, 'Tanamalwila', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1610, 0, NULL, 0, NULL, 0, NULL, 'Uva Gangodagama', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1611, 0, NULL, 0, NULL, 0, NULL, 'Uva Kudaoya', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1612, 0, NULL, 0, NULL, 0, NULL, 'Uva Pelawatta', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1613, 0, NULL, 0, NULL, 0, NULL, 'Warunagama', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1614, 0, NULL, 0, NULL, 0, NULL, 'Wedikumbura', 'CI', 'A', 33);
INSERT INTO `geo_area` VALUES (1615, 0, NULL, 0, NULL, 0, NULL, 'Alawatura', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1616, 0, NULL, 0, NULL, 0, NULL, 'Algama', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1617, 0, NULL, 0, NULL, 0, NULL, 'Alutnuwara', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1618, 0, NULL, 0, NULL, 0, NULL, 'Ambalakanda', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1619, 0, NULL, 0, NULL, 0, NULL, 'Ambulugala', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1620, 0, NULL, 0, NULL, 0, NULL, 'Amitirigala', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1621, 0, NULL, 0, NULL, 0, NULL, 'Ampagala', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1622, 0, NULL, 0, NULL, 0, NULL, 'Anhettigama', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1623, 0, NULL, 0, NULL, 0, NULL, 'Aranayaka', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1624, 0, NULL, 0, NULL, 0, NULL, 'Aruggammana', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1625, 0, NULL, 0, NULL, 0, NULL, 'Atale', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1626, 0, NULL, 0, NULL, 0, NULL, 'Batuwita', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1627, 0, NULL, 0, NULL, 0, NULL, 'Beligala(Sab)', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1628, 0, NULL, 0, NULL, 0, NULL, 'Berannawa', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1629, 0, NULL, 0, NULL, 0, NULL, 'Bopitiya', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1630, 0, NULL, 0, NULL, 0, NULL, 'Boralankada', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1631, 0, NULL, 0, NULL, 0, NULL, 'Bossella', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1632, 0, NULL, 0, NULL, 0, NULL, 'Bulathkohupitiya', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1633, 0, NULL, 0, NULL, 0, NULL, 'Damunupola', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1634, 0, NULL, 0, NULL, 0, NULL, 'Debathgama', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1635, 0, NULL, 0, NULL, 0, NULL, 'Dedugala', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1636, 0, NULL, 0, NULL, 0, NULL, 'Deewala Pallegama', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1637, 0, NULL, 0, NULL, 0, NULL, 'Dehiowita', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1638, 0, NULL, 0, NULL, 0, NULL, 'Deldeniya', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1639, 0, NULL, 0, NULL, 0, NULL, 'Deloluwa', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1640, 0, NULL, 0, NULL, 0, NULL, 'Deraniyagala', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1641, 0, NULL, 0, NULL, 0, NULL, 'Dewalegama', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1642, 0, NULL, 0, NULL, 0, NULL, 'Dewanagala', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1643, 0, NULL, 0, NULL, 0, NULL, 'Dombemada', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1644, 0, NULL, 0, NULL, 0, NULL, 'Dorawaka', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1645, 0, NULL, 0, NULL, 0, NULL, 'Maliboda', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1646, 0, NULL, 0, NULL, 0, NULL, 'Malmaduwa', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1647, 0, NULL, 0, NULL, 0, NULL, 'Dunumala', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1648, 0, NULL, 0, NULL, 0, NULL, 'Galapitamada', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1649, 0, NULL, 0, NULL, 0, NULL, 'Galatara', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1650, 0, NULL, 0, NULL, 0, NULL, 'Galigamuwa Town', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1651, 0, NULL, 0, NULL, 0, NULL, 'Galpatha(Sab)', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1652, 0, NULL, 0, NULL, 0, NULL, 'Galapitarnada', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1653, 0, NULL, 0, NULL, 0, NULL, 'Gantuna', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1654, 0, NULL, 0, NULL, 0, NULL, 'Gonagala', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1655, 0, NULL, 0, NULL, 0, NULL, 'Hakahinna', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1656, 0, NULL, 0, NULL, 0, NULL, 'Hakbellawaka', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1657, 0, NULL, 0, NULL, 0, NULL, 'Helamada', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1658, 0, NULL, 0, NULL, 0, NULL, 'Hemmatagama', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1659, 0, NULL, 0, NULL, 0, NULL, 'Hettimulla', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1660, 0, NULL, 0, NULL, 0, NULL, 'Hewadiwela', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1661, 0, NULL, 0, NULL, 0, NULL, 'Hingula', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1662, 0, NULL, 0, NULL, 0, NULL, 'Hinguralakanda', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1663, 0, NULL, 0, NULL, 0, NULL, 'Hiriwadunna', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1664, 0, NULL, 0, NULL, 0, NULL, 'Imbulana', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1665, 0, NULL, 0, NULL, 0, NULL, 'Imbulgasdeniya', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1666, 0, NULL, 0, NULL, 0, NULL, 'Kabagamuwa', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1667, 0, NULL, 0, NULL, 0, NULL, 'Kannattota', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1668, 0, NULL, 0, NULL, 0, NULL, 'Kehelpannala', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1669, 0, NULL, 0, NULL, 0, NULL, 'Kitulgala', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1670, 0, NULL, 0, NULL, 0, NULL, 'Kondeniya', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1671, 0, NULL, 0, NULL, 0, NULL, 'Kotiyakumbura', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1672, 0, NULL, 0, NULL, 0, NULL, 'Lewangama', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1673, 0, NULL, 0, NULL, 0, NULL, 'Mahabage', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1674, 0, NULL, 0, NULL, 0, NULL, 'Mahapallegama', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1675, 0, NULL, 0, NULL, 0, NULL, 'Maharangalla', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1676, 0, NULL, 0, NULL, 0, NULL, 'Makehelwala', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1677, 0, NULL, 0, NULL, 0, NULL, 'Malalpola', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1678, 0, NULL, 0, NULL, 0, NULL, 'Mawanella', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1679, 0, NULL, 0, NULL, 0, NULL, 'Miyanawita', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1680, 0, NULL, 0, NULL, 0, NULL, 'Molagoda', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1681, 0, NULL, 0, NULL, 0, NULL, 'Morontota', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1682, 0, NULL, 0, NULL, 0, NULL, 'Nelundeniya', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1683, 0, NULL, 0, NULL, 0, NULL, 'Niyadunjpola', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1684, 0, NULL, 0, NULL, 0, NULL, 'Noori', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1685, 0, NULL, 0, NULL, 0, NULL, 'Parape', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1686, 0, NULL, 0, NULL, 0, NULL, 'Pattampitiya', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1687, 0, NULL, 0, NULL, 0, NULL, 'Pitagaldeniya', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1688, 0, NULL, 0, NULL, 0, NULL, 'Pothukoladeniya', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1689, 0, NULL, 0, NULL, 0, NULL, 'Rambukkana', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1690, 0, NULL, 0, NULL, 0, NULL, 'Ruwanwella', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1691, 0, NULL, 0, NULL, 0, NULL, 'Seaforth Colony', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1692, 0, NULL, 0, NULL, 0, NULL, 'Talgaspitiya', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1693, 0, NULL, 0, NULL, 0, NULL, 'Teligama', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1694, 0, NULL, 0, NULL, 0, NULL, 'Tholangamuwa', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1695, 0, NULL, 0, NULL, 0, NULL, 'Thotawella', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1696, 0, NULL, 0, NULL, 0, NULL, 'Tulhiriya', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1697, 0, NULL, 0, NULL, 0, NULL, 'Tuntota', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1698, 0, NULL, 0, NULL, 0, NULL, 'Udagaldeniya', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1699, 0, NULL, 0, NULL, 0, NULL, 'Udapotha', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1700, 0, NULL, 0, NULL, 0, NULL, 'Udumulla', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1701, 0, NULL, 0, NULL, 0, NULL, 'Undugoda', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1702, 0, NULL, 0, NULL, 0, NULL, 'Ussapitiya', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1703, 0, NULL, 0, NULL, 0, NULL, 'Wahakula', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1704, 0, NULL, 0, NULL, 0, NULL, 'Waharaka', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1705, 0, NULL, 0, NULL, 0, NULL, 'Warakapola', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1706, 0, NULL, 0, NULL, 0, NULL, 'Watura', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1707, 0, NULL, 0, NULL, 0, NULL, 'Weeoya', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1708, 0, NULL, 0, NULL, 0, NULL, 'Wegalla', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1709, 0, NULL, 0, NULL, 0, NULL, 'Weragala', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1710, 0, NULL, 0, NULL, 0, NULL, 'Yatagama', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1711, 0, NULL, 0, NULL, 0, NULL, 'Yatapana', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1712, 0, NULL, 0, NULL, 0, NULL, 'Yatiyantota', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1713, 0, NULL, 0, NULL, 0, NULL, 'Yattogoda', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1714, 0, NULL, 0, NULL, 0, NULL, 'Akarella', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1715, 0, NULL, 0, NULL, 0, NULL, 'Atakalanpanna', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1716, 0, NULL, 0, NULL, 0, NULL, 'Ayagama', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1717, 0, NULL, 0, NULL, 0, NULL, 'Balangoda', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1718, 0, NULL, 0, NULL, 0, NULL, 'Batatota', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1719, 0, NULL, 0, NULL, 0, NULL, 'Belihuloya', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1720, 0, NULL, 0, NULL, 0, NULL, 'Boltumbe', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1721, 0, NULL, 0, NULL, 0, NULL, 'Bomluwagaina', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1722, 0, NULL, 0, NULL, 0, NULL, 'Boraluwageaina', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1723, 0, NULL, 0, NULL, 0, NULL, 'Dambuluwana', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1724, 0, NULL, 0, NULL, 0, NULL, 'Daugala', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1725, 0, NULL, 0, NULL, 0, NULL, 'Dela', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1726, 0, NULL, 0, NULL, 0, NULL, 'Delwala', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1727, 0, NULL, 0, NULL, 0, NULL, 'Demuwatha', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1728, 0, NULL, 0, NULL, 0, NULL, 'Dodampe', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1729, 0, NULL, 0, NULL, 0, NULL, 'Doloswalakanda', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1730, 0, NULL, 0, NULL, 0, NULL, 'Dumbara Manana', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1731, 0, NULL, 0, NULL, 0, NULL, 'Eheliyagoda', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1732, 0, NULL, 0, NULL, 0, NULL, 'Elapatha', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1733, 0, NULL, 0, NULL, 0, NULL, 'Ellagawa', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1734, 0, NULL, 0, NULL, 0, NULL, 'Ellaulla', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1735, 0, NULL, 0, NULL, 0, NULL, 'Ellawala', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1736, 0, NULL, 0, NULL, 0, NULL, 'Embilipitiya', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1737, 0, NULL, 0, NULL, 0, NULL, 'Eratna', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1738, 0, NULL, 0, NULL, 0, NULL, 'Erepola', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1739, 0, NULL, 0, NULL, 0, NULL, 'Gabbela', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1740, 0, NULL, 0, NULL, 0, NULL, 'Gallella', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1741, 0, NULL, 0, NULL, 0, NULL, 'Gangeya', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1742, 0, NULL, 0, NULL, 0, NULL, 'Gawaragiriya', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1743, 0, NULL, 0, NULL, 0, NULL, 'Getahetta', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1744, 0, NULL, 0, NULL, 0, NULL, 'Gillimale', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1745, 0, NULL, 0, NULL, 0, NULL, 'Godagampola', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1746, 0, NULL, 0, NULL, 0, NULL, 'Godakawela', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1747, 0, NULL, 0, NULL, 0, NULL, 'Gurubewilagama', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1748, 0, NULL, 0, NULL, 0, NULL, 'Halpe', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1749, 0, NULL, 0, NULL, 0, NULL, 'Halwinna', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1750, 0, NULL, 0, NULL, 0, NULL, 'Handagiriya', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1751, 0, NULL, 0, NULL, 0, NULL, 'Hapugastenna', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1752, 0, NULL, 0, NULL, 0, NULL, 'Hatangala', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1753, 0, NULL, 0, NULL, 0, NULL, 'Haterabage', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1754, 0, NULL, 0, NULL, 0, NULL, 'Hidellana', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1755, 0, NULL, 0, NULL, 0, NULL, 'Hiramadagama', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1756, 0, NULL, 0, NULL, 0, NULL, 'Ilahagama', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1757, 0, NULL, 0, NULL, 0, NULL, 'Ittakanda', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1758, 0, NULL, 0, NULL, 0, NULL, 'Kahangama', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1759, 0, NULL, 0, NULL, 0, NULL, 'Kahawatta', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1760, 0, NULL, 0, NULL, 0, NULL, 'Kalawana', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1761, 0, NULL, 0, NULL, 0, NULL, 'Kaltota', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1762, 0, NULL, 0, NULL, 0, NULL, 'Karangoda', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1763, 0, NULL, 0, NULL, 0, NULL, 'KellaJunction', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1764, 0, NULL, 0, NULL, 0, NULL, 'Kiriella', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1765, 0, NULL, 0, NULL, 0, NULL, 'Kolombugama', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1766, 0, NULL, 0, NULL, 0, NULL, 'Kolonna', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1767, 0, NULL, 0, NULL, 0, NULL, 'Kotawehera Mankada', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1768, 0, NULL, 0, NULL, 0, NULL, 'Kudawa', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1769, 0, NULL, 0, NULL, 0, NULL, 'Kuruwita', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1770, 0, NULL, 0, NULL, 0, NULL, 'Lellopitiya', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1771, 0, NULL, 0, NULL, 0, NULL, 'lmbulpe', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1772, 0, NULL, 0, NULL, 0, NULL, 'Madalagama', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1773, 0, NULL, 0, NULL, 0, NULL, 'Mahawalatenna', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1774, 0, NULL, 0, NULL, 0, NULL, 'Makandura Sabara', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1775, 0, NULL, 0, NULL, 0, NULL, 'Malwala Junction', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1776, 0, NULL, 0, NULL, 0, NULL, 'Marapana', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1777, 0, NULL, 0, NULL, 0, NULL, 'Matuwagalagama', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1778, 0, NULL, 0, NULL, 0, NULL, 'Medagalatur', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1779, 0, NULL, 0, NULL, 0, NULL, 'Meddekanda', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1780, 0, NULL, 0, NULL, 0, NULL, 'Minipura Dumbara', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1781, 0, NULL, 0, NULL, 0, NULL, 'Morahela', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1782, 0, NULL, 0, NULL, 0, NULL, 'Mulendiyawala', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1783, 0, NULL, 0, NULL, 0, NULL, 'Mulgama', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1784, 0, NULL, 0, NULL, 0, NULL, 'Nawalakanda', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1785, 0, NULL, 0, NULL, 0, NULL, 'NawinnaPinnakanda', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1786, 0, NULL, 0, NULL, 0, NULL, 'Niralagama', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1787, 0, NULL, 0, NULL, 0, NULL, 'Nivitigala', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1788, 0, NULL, 0, NULL, 0, NULL, 'Omalpe', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1789, 0, NULL, 0, NULL, 0, NULL, 'Opanayaka', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1790, 0, NULL, 0, NULL, 0, NULL, 'Padalangala', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1791, 0, NULL, 0, NULL, 0, NULL, 'Pallebedda', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1792, 0, NULL, 0, NULL, 0, NULL, 'Pambagolla', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1793, 0, NULL, 0, NULL, 0, NULL, 'Panamura', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1794, 0, NULL, 0, NULL, 0, NULL, 'Panapitiya', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1795, 0, NULL, 0, NULL, 0, NULL, 'Panapola', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1796, 0, NULL, 0, NULL, 0, NULL, 'Panawala', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1797, 0, NULL, 0, NULL, 0, NULL, 'Parakaduwa', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1798, 0, NULL, 0, NULL, 0, NULL, 'Pebotuwa', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1799, 0, NULL, 0, NULL, 0, NULL, 'Pelmadulla', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1800, 0, NULL, 0, NULL, 0, NULL, 'Pimbura', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1801, 0, NULL, 0, NULL, 0, NULL, 'Pinnawala', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1802, 0, NULL, 0, NULL, 0, NULL, 'Pothupitia', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1803, 0, NULL, 0, NULL, 0, NULL, 'Rajawaka', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1804, 0, NULL, 0, NULL, 0, NULL, 'Rakwana', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1805, 0, NULL, 0, NULL, 0, NULL, 'Ranwala', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1806, 0, NULL, 0, NULL, 0, NULL, 'Ratna Hangamuwa', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1807, 0, NULL, 0, NULL, 0, NULL, 'Ratnapura', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1808, 0, NULL, 0, NULL, 0, NULL, 'Samanalawewa', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1809, 0, NULL, 0, NULL, 0, NULL, 'Sri Palabadala', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1810, 0, NULL, 0, NULL, 0, NULL, 'Sudagala', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1811, 0, NULL, 0, NULL, 0, NULL, 'Talakolahinna', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1812, 0, NULL, 0, NULL, 0, NULL, 'Tangantenna', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1813, 0, NULL, 0, NULL, 0, NULL, 'Teppanyaki', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1814, 0, NULL, 0, NULL, 0, NULL, 'Tunkama', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1815, 0, NULL, 0, NULL, 0, NULL, 'Udaha Hawupe', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1816, 0, NULL, 0, NULL, 0, NULL, 'Udakarawita', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1817, 0, NULL, 0, NULL, 0, NULL, 'Udaniriella', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1818, 0, NULL, 0, NULL, 0, NULL, 'Udawalawe', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1819, 0, NULL, 0, NULL, 0, NULL, 'Ullinduwawa', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1820, 0, NULL, 0, NULL, 0, NULL, 'Veddagala', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1821, 0, NULL, 0, NULL, 0, NULL, 'Vijeria', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1822, 0, NULL, 0, NULL, 0, NULL, 'Waleboda', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1823, 0, NULL, 0, NULL, 0, NULL, 'Watapotha', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1824, 0, NULL, 0, NULL, 0, NULL, 'Waturawa', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1825, 0, NULL, 0, NULL, 0, NULL, 'Weligepola', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1826, 0, NULL, 0, NULL, 0, NULL, 'Welipathayaya', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1827, 0, NULL, 0, NULL, 0, NULL, 'Wewelwatta', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1828, 0, NULL, 0, NULL, 0, NULL, 'Wikiliya', 'CI', 'A', 35);
INSERT INTO `geo_area` VALUES (1829, 0, NULL, 0, NULL, 0, NULL, 'Nuwara Eliya', 'CI', 'A', 16);
INSERT INTO `geo_area` VALUES (1830, 0, NULL, 0, NULL, 0, NULL, 'Weligama', 'CI', 'A', 26);
INSERT INTO `geo_area` VALUES (1831, 0, NULL, 0, NULL, 0, NULL, 'Muthur', 'CI', 'A', 19);
INSERT INTO `geo_area` VALUES (1832, 0, NULL, 0, NULL, 0, NULL, 'Vaddukodai', 'CI', 'A', 20);
INSERT INTO `geo_area` VALUES (1833, 0, NULL, 0, NULL, 0, NULL, 'Kayts', 'CI', 'A', 20);
INSERT INTO `geo_area` VALUES (1834, 0, NULL, 0, NULL, 0, NULL, 'Atchuvely', 'CI', 'A', 20);
INSERT INTO `geo_area` VALUES (1835, 0, NULL, 0, NULL, 0, NULL, 'Kegalle', 'CI', 'A', 34);
INSERT INTO `geo_area` VALUES (1836, 0, NULL, 0, NULL, 0, NULL, 'Kiribathgoda', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (1837, 0, NULL, 0, NULL, 0, NULL, 'Mawaramandiya', 'CI', 'A', 12);
INSERT INTO `geo_area` VALUES (1838, 0, NULL, 0, NULL, 0, NULL, 'Kottawa', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (1839, 0, NULL, 0, NULL, 0, NULL, 'Kotikawatta', 'CI', 'A', 11);
INSERT INTO `geo_area` VALUES (1840, 0, NULL, 0, NULL, 0, NULL, 'Rawathawaththa', 'CI', 'A', 11);

-- ----------------------------
-- Table structure for group_privilege
-- ----------------------------
DROP TABLE IF EXISTS `group_privilege`;
CREATE TABLE `group_privilege`  (
  `group_privilege_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `access_group` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `system_menu_menu_item_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`group_privilege_id`) USING BTREE,
  INDEX `FKs3r4n2ovvuv2qmxuywttwqahr`(`system_menu_menu_item_id`) USING BTREE,
  CONSTRAINT `FKs3r4n2ovvuv2qmxuywttwqahr` FOREIGN KEY (`system_menu_menu_item_id`) REFERENCES `system_menu` (`menu_item_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 70 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of group_privilege
-- ----------------------------
INSERT INTO `group_privilege` VALUES (1, 0, '2025-05-05 14:24:55.686000', 0, '2025-05-05 14:24:55.686000', 0, 'ADM', 'A', 4);
INSERT INTO `group_privilege` VALUES (2, 0, '2025-05-05 14:24:55.713000', 0, '2025-05-05 14:24:55.713000', 0, 'ADM', 'A', 5);
INSERT INTO `group_privilege` VALUES (3, 0, '2025-05-05 14:24:55.745000', 0, '2025-05-05 14:24:55.745000', 0, 'ADM', 'A', 1);
INSERT INTO `group_privilege` VALUES (4, 0, '2025-05-05 14:24:55.751000', 0, '2025-05-05 14:24:55.751000', 0, 'ADM', 'A', 2);
INSERT INTO `group_privilege` VALUES (6, 0, '2025-05-05 21:06:55.791000', 0, '2025-05-05 21:06:55.791000', 0, 'ADM', 'A', 6);
INSERT INTO `group_privilege` VALUES (7, 0, '2025-05-05 21:06:55.819000', 0, '2025-05-05 21:06:55.819000', 0, 'ADM', 'A', 10);
INSERT INTO `group_privilege` VALUES (8, 0, '2025-05-05 21:06:55.838000', 0, '2025-08-03 13:31:42.969000', 1, 'ADM', 'I', 7);
INSERT INTO `group_privilege` VALUES (9, 0, '2025-05-05 21:06:55.858000', 0, '2025-05-05 21:06:55.858000', 0, 'ADM', 'A', 8);
INSERT INTO `group_privilege` VALUES (10, 0, '2025-05-05 21:06:55.877000', 0, '2025-05-05 21:06:55.877000', 0, 'ADM', 'A', 9);
INSERT INTO `group_privilege` VALUES (11, 0, '2025-05-05 21:06:55.898000', 0, '2025-05-05 21:06:55.898000', 0, 'ADM', 'A', 11);
INSERT INTO `group_privilege` VALUES (12, 0, '2025-05-05 21:06:55.904000', 0, '2025-05-05 21:06:55.904000', 0, 'ADM', 'A', 12);
INSERT INTO `group_privilege` VALUES (13, 0, '2025-05-05 21:06:55.925000', 0, '2025-08-01 10:08:21.752000', 1, 'ADM', 'I', 13);
INSERT INTO `group_privilege` VALUES (14, 0, '2025-05-05 21:06:55.943000', 0, '2025-05-05 21:06:55.943000', 0, 'ADM', 'A', 14);
INSERT INTO `group_privilege` VALUES (15, 0, '2025-05-05 21:06:55.961000', 0, '2025-05-05 21:06:55.961000', 0, 'ADM', 'A', 15);
INSERT INTO `group_privilege` VALUES (16, 0, '2025-05-05 21:06:55.979000', 0, '2025-05-05 21:06:55.979000', 0, 'ADM', 'A', 16);
INSERT INTO `group_privilege` VALUES (17, 0, '2025-05-05 21:06:55.985000', 0, '2025-05-05 21:06:55.985000', 0, 'ADM', 'A', 17);
INSERT INTO `group_privilege` VALUES (18, 0, '2025-05-05 21:06:56.003000', 0, '2025-05-05 21:06:56.003000', 0, 'ADM', 'A', 18);
INSERT INTO `group_privilege` VALUES (19, 0, '2025-05-05 21:06:56.026000', 0, '2025-08-03 13:31:43.011000', 1, 'ADM', 'I', 19);
INSERT INTO `group_privilege` VALUES (20, 0, '2025-05-05 21:06:56.050000', 0, '2025-05-05 21:06:56.050000', 0, 'ADM', 'A', 20);
INSERT INTO `group_privilege` VALUES (21, 0, '2025-05-05 21:06:56.062000', 0, '2025-05-05 21:06:56.062000', 0, 'ADM', 'A', 21);
INSERT INTO `group_privilege` VALUES (22, 0, '2025-06-17 19:42:31.054000', 0, '2025-06-17 19:42:31.054000', 0, 'ADM', 'A', 22);
INSERT INTO `group_privilege` VALUES (23, 0, '2025-06-17 19:42:31.063000', 0, '2025-06-17 19:46:01.794000', 2, 'ADM', 'A', 23);
INSERT INTO `group_privilege` VALUES (24, 0, '2025-06-20 19:54:32.983000', 0, '2025-06-20 19:54:32.983000', 0, 'ADM', 'A', 24);
INSERT INTO `group_privilege` VALUES (25, 0, '2025-06-28 20:30:53.760000', 0, '2025-06-28 20:30:53.760000', 0, 'ADM', 'A', 25);
INSERT INTO `group_privilege` VALUES (26, 0, '2025-07-12 21:48:54.121000', 0, '2025-08-03 13:31:43.004000', 1, 'ADM', 'I', 26);
INSERT INTO `group_privilege` VALUES (27, 0, '2025-07-29 19:33:30.170000', 0, '2025-07-29 19:33:30.170000', 0, 'ADM', 'A', 27);
INSERT INTO `group_privilege` VALUES (28, 0, '2025-08-01 11:57:42.145000', 0, '2025-08-01 11:57:42.145000', 0, 'ADM', 'A', 28);
INSERT INTO `group_privilege` VALUES (29, 0, '2025-08-03 01:18:44.276000', 0, '2025-08-03 01:18:44.276000', 0, 'ADM', 'A', 29);
INSERT INTO `group_privilege` VALUES (30, 0, '2025-08-03 11:56:43.195000', 0, '2025-08-03 11:56:43.195000', 0, 'MGR', 'A', 1);
INSERT INTO `group_privilege` VALUES (31, 0, '2025-08-03 11:56:43.230000', 0, '2025-08-03 11:56:43.230000', 0, 'MGR', 'A', 2);
INSERT INTO `group_privilege` VALUES (32, 0, '2025-08-03 11:56:43.262000', 0, '2025-08-03 11:56:43.262000', 0, 'MGR', 'A', 10);
INSERT INTO `group_privilege` VALUES (33, 0, '2025-08-03 11:56:43.334000', 0, '2025-08-03 11:56:43.334000', 0, 'MGR', 'A', 28);
INSERT INTO `group_privilege` VALUES (34, 0, '2025-08-03 11:56:44.110000', 0, '2025-08-03 11:56:44.110000', 0, 'MGR', 'A', 4);
INSERT INTO `group_privilege` VALUES (35, 0, '2025-08-03 11:56:44.115000', 0, '2025-08-03 11:56:44.115000', 0, 'MGR', 'A', 5);
INSERT INTO `group_privilege` VALUES (36, 0, '2025-08-03 11:56:44.129000', 0, '2025-08-03 11:56:44.129000', 0, 'MGR', 'A', 7);
INSERT INTO `group_privilege` VALUES (37, 0, '2025-08-03 11:56:44.142000', 0, '2025-08-03 11:56:44.142000', 0, 'MGR', 'A', 8);
INSERT INTO `group_privilege` VALUES (38, 0, '2025-08-03 11:56:44.158000', 0, '2025-08-03 11:56:44.158000', 0, 'MGR', 'A', 9);
INSERT INTO `group_privilege` VALUES (39, 0, '2025-08-03 11:56:44.176000', 0, '2025-08-03 11:56:44.176000', 0, 'MGR', 'A', 24);
INSERT INTO `group_privilege` VALUES (40, 0, '2025-08-03 11:56:44.191000', 0, '2025-08-03 11:56:44.191000', 0, 'MGR', 'A', 11);
INSERT INTO `group_privilege` VALUES (41, 0, '2025-08-03 11:56:44.197000', 0, '2025-08-03 11:56:44.197000', 0, 'MGR', 'A', 12);
INSERT INTO `group_privilege` VALUES (42, 0, '2025-08-03 11:56:44.211000', 0, '2025-08-03 11:56:44.211000', 0, 'MGR', 'A', 13);
INSERT INTO `group_privilege` VALUES (43, 0, '2025-08-03 11:56:44.231000', 0, '2025-08-03 11:56:44.231000', 0, 'MGR', 'A', 14);
INSERT INTO `group_privilege` VALUES (44, 0, '2025-08-03 11:56:44.244000', 0, '2025-08-03 11:56:44.244000', 0, 'MGR', 'A', 15);
INSERT INTO `group_privilege` VALUES (45, 0, '2025-08-03 11:56:44.257000', 0, '2025-08-03 11:56:44.257000', 0, 'MGR', 'A', 16);
INSERT INTO `group_privilege` VALUES (46, 0, '2025-08-03 11:56:44.257000', 0, '2025-08-03 11:56:44.257000', 0, 'MGR', 'A', 17);
INSERT INTO `group_privilege` VALUES (47, 0, '2025-08-03 11:56:44.282000', 0, '2025-08-03 11:56:44.282000', 0, 'MGR', 'A', 18);
INSERT INTO `group_privilege` VALUES (48, 0, '2025-08-03 11:56:44.293000', 0, '2025-08-03 11:56:44.293000', 0, 'MGR', 'A', 20);
INSERT INTO `group_privilege` VALUES (49, 0, '2025-08-03 11:56:44.299000', 0, '2025-08-03 11:56:44.299000', 0, 'MGR', 'A', 21);
INSERT INTO `group_privilege` VALUES (50, 0, '2025-08-03 11:56:44.315000', 0, '2025-08-03 11:56:44.315000', 0, 'MGR', 'A', 22);
INSERT INTO `group_privilege` VALUES (51, 0, '2025-08-03 11:56:44.324000', 0, '2025-08-03 11:56:44.324000', 0, 'MGR', 'A', 23);
INSERT INTO `group_privilege` VALUES (52, 0, '2025-08-03 11:56:44.339000', 0, '2025-08-03 11:56:44.339000', 0, 'MGR', 'A', 25);
INSERT INTO `group_privilege` VALUES (53, 0, '2025-08-03 11:56:44.353000', 0, '2025-08-03 11:56:44.353000', 0, 'MGR', 'A', 27);
INSERT INTO `group_privilege` VALUES (54, 0, '2025-08-03 11:56:44.367000', 0, '2025-08-03 11:56:44.367000', 0, 'MGR', 'A', 29);
INSERT INTO `group_privilege` VALUES (55, 0, '2025-08-03 12:00:42.001000', 0, '2025-08-03 12:00:42.001000', 0, 'OFF', 'A', 1);
INSERT INTO `group_privilege` VALUES (56, 0, '2025-08-03 12:00:42.049000', 0, '2025-08-03 12:00:42.049000', 0, 'OFF', 'A', 2);
INSERT INTO `group_privilege` VALUES (57, 0, '2025-08-03 12:00:42.049000', 0, '2025-08-03 12:00:42.049000', 0, 'OFF', 'A', 28);
INSERT INTO `group_privilege` VALUES (58, 0, '2025-08-03 12:00:42.065000', 0, '2025-08-03 12:00:42.065000', 0, 'OFF', 'A', 10);
INSERT INTO `group_privilege` VALUES (59, 0, '2025-08-03 12:00:42.083000', 0, '2025-08-03 12:00:42.083000', 0, 'OFF', 'A', 20);
INSERT INTO `group_privilege` VALUES (60, 0, '2025-08-03 12:00:42.097000', 0, '2025-08-03 12:00:42.097000', 0, 'OFF', 'A', 21);
INSERT INTO `group_privilege` VALUES (61, 0, '2025-08-03 13:24:36.891000', 0, '2025-08-03 13:24:36.891000', 0, 'OFF', 'A', 11);
INSERT INTO `group_privilege` VALUES (62, 0, '2025-08-03 13:24:36.977000', 0, '2025-08-03 13:24:36.977000', 0, 'OFF', 'A', 15);
INSERT INTO `group_privilege` VALUES (63, 0, '2025-08-03 13:24:36.999000', 0, '2025-08-03 13:24:36.999000', 0, 'OFF', 'A', 14);
INSERT INTO `group_privilege` VALUES (64, 0, '2025-08-03 13:24:37.021000', 0, '2025-08-03 13:24:37.021000', 0, 'OFF', 'A', 12);
INSERT INTO `group_privilege` VALUES (65, 0, '2025-08-03 13:24:37.037000', 0, '2025-08-03 13:24:37.037000', 0, 'OFF', 'A', 4);
INSERT INTO `group_privilege` VALUES (66, 0, '2025-08-03 13:24:37.044000', 0, '2025-08-03 13:24:37.044000', 0, 'OFF', 'A', 9);
INSERT INTO `group_privilege` VALUES (67, 0, '2025-08-03 13:24:37.061000', 0, '2025-08-03 13:24:37.061000', 0, 'OFF', 'A', 24);
INSERT INTO `group_privilege` VALUES (68, 0, '2025-08-03 13:24:37.075000', 0, '2025-08-03 13:24:37.075000', 0, 'OFF', 'A', 16);
INSERT INTO `group_privilege` VALUES (69, 0, '2025-08-03 13:24:37.082000', 0, '2025-08-03 13:24:37.082000', 0, 'OFF', 'A', 18);

-- ----------------------------
-- Table structure for lecture_room
-- ----------------------------
DROP TABLE IF EXISTS `lecture_room`;
CREATE TABLE `lecture_room`  (
  `lecture_room_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `capacity` int(11) NULL DEFAULT NULL,
  `description` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `location` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `room_code` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  PRIMARY KEY (`lecture_room_id`) USING BTREE,
  UNIQUE INDEX `UK5dv2lhnkn3e60v16ibwkv8tap`(`room_code`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of lecture_room
-- ----------------------------
INSERT INTO `lecture_room` VALUES (1, 25, 'Computer Lab 1', 'Ground Floor', 'LAB1', 'A');
INSERT INTO `lecture_room` VALUES (2, 40, 'saasd', 'adasd', 'AA', 'D');
INSERT INTO `lecture_room` VALUES (3, 50, 'Lecture Hall 1', '3rd Floor', 'R1', 'A');
INSERT INTO `lecture_room` VALUES (4, 50, 'Lecture Hall 2', '1st Floor', 'R2', 'A');

-- ----------------------------
-- Table structure for lecturer
-- ----------------------------
DROP TABLE IF EXISTS `lecturer`;
CREATE TABLE `lecturer`  (
  `lecturer_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `address` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `availability` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `description` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `email` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `first_name` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `image` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `initials` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `last_name` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `mobile_no` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `city_geo_area_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`lecturer_id`) USING BTREE,
  INDEX `FK9y51fmwkm49d2he3d3v0fir6l`(`city_geo_area_id`) USING BTREE,
  CONSTRAINT `FK9y51fmwkm49d2he3d3v0fir6l` FOREIGN KEY (`city_geo_area_id`) REFERENCES `geo_area` (`geo_area_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of lecturer
-- ----------------------------
INSERT INTO `lecturer` VALUES (1, 0, '2025-05-25 14:43:14.825000', 0, '2025-05-25 14:43:14.825000', 0, NULL, 'F', NULL, 'test@gmail.com', 'Afran', NULL, NULL, 'Adahan', '0767899222', 'A', NULL);
INSERT INTO `lecturer` VALUES (2, 0, '2025-05-25 15:06:36.859000', 0, '2025-05-25 15:06:36.859000', 0, NULL, 'F', NULL, 'test@gmail.com', 'Tuan', NULL, NULL, 'Adahan', '0712345789', 'A', NULL);

-- ----------------------------
-- Table structure for officer
-- ----------------------------
DROP TABLE IF EXISTS `officer`;
CREATE TABLE `officer`  (
  `officer_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `email` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `joined_date` date NULL DEFAULT NULL,
  `mobile_no` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `name` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `officer_category` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `password` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `reset_password` bit(1) NOT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  PRIMARY KEY (`officer_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of officer
-- ----------------------------
INSERT INTO `officer` VALUES (1, 0, NULL, 0, NULL, 0, 'admin', NULL, NULL, 'Admin', 'ADM', 'K69RnEal/IrFaFKX11esHQ==', b'0', 'A');
INSERT INTO `officer` VALUES (2, 0, '2025-08-03 11:54:47.901000', 0, '2025-08-03 11:54:47.901000', 0, 'adahan@gmail.com', '2025-08-03', '0784548788', 'Tuan Adahan', 'MGR', 'K69RnEal/IrFaFKX11esHQ==', b'1', 'A');
INSERT INTO `officer` VALUES (3, 0, '2025-08-03 11:55:56.264000', 0, '2025-08-03 11:55:56.264000', 0, 'binthari@gmail.com', '2025-08-03', '0764521215', 'Binthari Adahan', 'OFF', 'K69RnEal/IrFaFKX11esHQ==', b'1', 'A');

-- ----------------------------
-- Table structure for payment_history
-- ----------------------------
DROP TABLE IF EXISTS `payment_history`;
CREATE TABLE `payment_history`  (
  `payment_history_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `collected_by` bigint(20) NOT NULL,
  `paid_amount` double NOT NULL,
  `paid_date` date NULL DEFAULT NULL,
  `payment_method` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `reference_no` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `remark` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `payment_schedule_payment_schedule_id` bigint(20) NULL DEFAULT NULL,
  `student_student_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`payment_history_id`) USING BTREE,
  INDEX `FKekxl74j5hxjefxriah881t8a6`(`payment_schedule_payment_schedule_id`) USING BTREE,
  INDEX `FKkliktqdpmckmpee53mi6rhair`(`student_student_id`) USING BTREE,
  CONSTRAINT `FKekxl74j5hxjefxriah881t8a6` FOREIGN KEY (`payment_schedule_payment_schedule_id`) REFERENCES `payment_schedule` (`payment_schedule_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FKkliktqdpmckmpee53mi6rhair` FOREIGN KEY (`student_student_id`) REFERENCES `student` (`student_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of payment_history
-- ----------------------------
INSERT INTO `payment_history` VALUES (1, 0, '2025-08-03 13:32:20.836000', 0, '2025-08-03 13:32:20.836000', 0, 1, 10000, '2025-08-03', 'CASH', '202508031', NULL, 3, 5);
INSERT INTO `payment_history` VALUES (2, 0, '2025-08-03 13:58:16.199000', 0, '2025-08-03 13:58:16.199000', 0, 2, 10000, '2025-08-03', 'CASH', '202508032', NULL, 8, 15);

-- ----------------------------
-- Table structure for payment_schedule
-- ----------------------------
DROP TABLE IF EXISTS `payment_schedule`;
CREATE TABLE `payment_schedule`  (
  `payment_schedule_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `amount_due` double NOT NULL,
  `due_date` date NULL DEFAULT NULL,
  `pay_later_count` int(11) NOT NULL,
  `pay_later_requested` bit(1) NOT NULL,
  `student_payment_structure_student_payment_structure_id` bigint(20) NULL DEFAULT NULL,
  `description` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  PRIMARY KEY (`payment_schedule_id`) USING BTREE,
  INDEX `FKitpn3kxkpk4p7ep1rsu3fiu5l`(`student_payment_structure_student_payment_structure_id`) USING BTREE,
  CONSTRAINT `FKitpn3kxkpk4p7ep1rsu3fiu5l` FOREIGN KEY (`student_payment_structure_student_payment_structure_id`) REFERENCES `student_payment_structure` (`student_payment_structure_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 18 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of payment_schedule
-- ----------------------------
INSERT INTO `payment_schedule` VALUES (1, 0, '2025-08-01 15:38:36.315000', 0, '2025-08-03 14:04:53.298000', 2, 45000, '2025-08-01', 1, b'0', 1, NULL);
INSERT INTO `payment_schedule` VALUES (2, 0, '2025-08-01 15:38:36.340000', 0, '2025-08-01 15:38:36.340000', 0, 1500, '2025-10-31', 0, b'0', 2, NULL);
INSERT INTO `payment_schedule` VALUES (3, 0, '2025-08-03 07:02:58.353000', 0, '2025-08-03 07:02:58.353000', 0, 10000, '2025-08-03', 0, b'0', 3, 'Installment 1');
INSERT INTO `payment_schedule` VALUES (4, 0, '2025-08-03 07:02:58.367000', 0, '2025-08-03 07:02:58.367000', 0, 10000, '2025-09-03', 0, b'0', 3, 'Installment 2');
INSERT INTO `payment_schedule` VALUES (5, 0, '2025-08-03 07:02:58.378000', 0, '2025-08-03 07:02:58.378000', 0, 10000, '2025-10-03', 0, b'0', 3, 'Installment 3');
INSERT INTO `payment_schedule` VALUES (6, 0, '2025-08-03 07:02:58.384000', 0, '2025-08-03 07:02:58.384000', 0, 10000, '2025-11-03', 0, b'0', 3, 'Installment 4');
INSERT INTO `payment_schedule` VALUES (7, 0, '2025-08-03 07:02:58.394000', 0, '2025-08-03 07:02:58.394000', 0, 10000, '2025-12-03', 0, b'0', 3, 'Installment 5');
INSERT INTO `payment_schedule` VALUES (8, 0, '2025-08-03 13:57:47.121000', 0, '2025-08-03 13:57:47.121000', 0, 10000, '2025-08-03', 0, b'0', 4, 'Installment 1');
INSERT INTO `payment_schedule` VALUES (9, 0, '2025-08-03 13:57:47.130000', 0, '2025-08-03 13:57:47.130000', 0, 10000, '2025-09-03', 0, b'0', 4, 'Installment 2');
INSERT INTO `payment_schedule` VALUES (10, 0, '2025-08-03 13:57:47.137000', 0, '2025-08-03 13:57:47.137000', 0, 10000, '2025-10-03', 0, b'0', 4, 'Installment 3');
INSERT INTO `payment_schedule` VALUES (11, 0, '2025-08-03 13:57:47.143000', 0, '2025-08-03 13:57:47.143000', 0, 10000, '2025-11-03', 0, b'0', 4, 'Installment 4');
INSERT INTO `payment_schedule` VALUES (12, 0, '2025-08-03 13:57:47.148000', 0, '2025-08-03 13:57:47.148000', 0, 10000, '2025-12-03', 0, b'0', 4, 'Installment 5');
INSERT INTO `payment_schedule` VALUES (15, 0, '2025-08-03 15:06:03.025000', 0, '2025-08-03 15:06:03.025000', 0, 35000, '2025-08-03', 0, b'0', 7, 'Full Payment');
INSERT INTO `payment_schedule` VALUES (16, 0, '2025-08-03 15:07:53.833000', 0, '2025-08-03 15:07:53.833000', 0, 35000, '2025-08-03', 0, b'0', 8, 'Full Payment');
INSERT INTO `payment_schedule` VALUES (17, 0, '2025-08-03 15:09:29.616000', 0, '2025-08-03 15:09:29.616000', 0, 30000, '2025-08-03', 0, b'0', 9, 'Full Payment');

-- ----------------------------
-- Table structure for payment_structure
-- ----------------------------
DROP TABLE IF EXISTS `payment_structure`;
CREATE TABLE `payment_structure`  (
  `payment_structure_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `description` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `due_date` date NULL DEFAULT NULL,
  `installment_amount` double NULL DEFAULT NULL,
  `installment_available` bit(1) NOT NULL,
  `installment_count` int(11) NOT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `total_amount` double NULL DEFAULT NULL,
  `type` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `course_course_id` bigint(20) NULL DEFAULT NULL,
  `main_payment_structure_payment_structure_id` bigint(20) NULL DEFAULT NULL,
  `semester_semester_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`payment_structure_id`) USING BTREE,
  INDEX `FKg3646b3te73wkoxrcjel7juph`(`course_course_id`) USING BTREE,
  INDEX `FK13ioxnc1eb32v5h9ni1cbmuaa`(`main_payment_structure_payment_structure_id`) USING BTREE,
  INDEX `FKgc17j00tf94lwt6d7jsmpjvm2`(`semester_semester_id`) USING BTREE,
  CONSTRAINT `FK13ioxnc1eb32v5h9ni1cbmuaa` FOREIGN KEY (`main_payment_structure_payment_structure_id`) REFERENCES `payment_structure` (`payment_structure_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FKg3646b3te73wkoxrcjel7juph` FOREIGN KEY (`course_course_id`) REFERENCES `course` (`course_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FKgc17j00tf94lwt6d7jsmpjvm2` FOREIGN KEY (`semester_semester_id`) REFERENCES `semester` (`semester_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 12 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of payment_structure
-- ----------------------------
INSERT INTO `payment_structure` VALUES (1, 1, '2025-08-01 10:53:02.760000', 1, '2025-08-01 12:10:56.253000', 1, 'Full Payment', NULL, 0, b'0', 0, 'A', 45000, 'M', 1, NULL, 1);
INSERT INTO `payment_structure` VALUES (2, 1, '2025-08-01 10:54:39.644000', 0, '2025-08-01 10:54:39.644000', 0, 'Instalment Payment', NULL, 10000, b'1', 5, 'A', 50000, 'M', 1, NULL, 1);
INSERT INTO `payment_structure` VALUES (3, 1, '2025-08-01 12:10:56.408000', 1, '2025-08-02 22:31:25.432000', 1, 'Tutes', '2025-10-31', NULL, b'0', 0, 'A', 1500, NULL, 1, 1, 1);
INSERT INTO `payment_structure` VALUES (5, 1, '2025-08-03 11:22:10.320000', 0, '2025-08-03 11:22:10.320000', 0, 'Installment Payment', NULL, 10000, b'1', 5, 'A', 50000, 'M', 1, NULL, 2);
INSERT INTO `payment_structure` VALUES (6, 1, '2025-08-03 13:46:41.277000', 0, '2025-08-03 13:46:41.277000', 0, 'Full Payment', NULL, NULL, b'0', 0, 'A', 40000, 'M', 1, NULL, 2);
INSERT INTO `payment_structure` VALUES (7, 1, '2025-08-03 13:47:09.546000', 0, '2025-08-03 13:47:09.546000', 0, 'Full Payment', NULL, NULL, b'0', 0, 'A', 53000, 'M', 1, NULL, 3);
INSERT INTO `payment_structure` VALUES (8, 1, '2025-08-03 13:47:39.761000', 0, '2025-08-03 13:47:39.761000', 0, 'Installment Payment', NULL, 11000, b'1', 5, 'A', 55000, 'M', 1, NULL, 3);
INSERT INTO `payment_structure` VALUES (9, 1, '2025-08-03 13:48:07.866000', 0, '2025-08-03 13:48:07.866000', 0, 'Full Payment', NULL, NULL, b'0', 0, 'A', 50000, 'M', 1, NULL, 4);
INSERT INTO `payment_structure` VALUES (10, 1, '2025-08-03 13:48:23.905000', 0, '2025-08-03 13:48:23.905000', 0, 'Full Payment', NULL, NULL, b'0', 0, 'A', 50000, 'M', 1, NULL, 5);
INSERT INTO `payment_structure` VALUES (11, 1, '2025-08-03 13:49:01.815000', 0, '2025-08-03 13:49:01.815000', 0, 'Full Payment', NULL, NULL, b'0', 0, 'A', 55000, 'M', 1, NULL, 6);

-- ----------------------------
-- Table structure for question
-- ----------------------------
DROP TABLE IF EXISTS `question`;
CREATE TABLE `question`  (
  `question_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `answer1img` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `answer1text` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `answer2img` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `answer2text` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `answer3img` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `answer3text` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `answer4img` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `answer4text` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `answer5img` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `answer5text` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `correct_answer` int(11) NOT NULL,
  `exam_question_no` int(11) NOT NULL,
  `is_answer1correct` bit(1) NOT NULL,
  `is_answer2correct` bit(1) NOT NULL,
  `is_answer3correct` bit(1) NOT NULL,
  `is_answer4correct` bit(1) NOT NULL,
  `is_answer5correct` bit(1) NOT NULL,
  `option1aimg` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option1atext` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option1bimg` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option1btext` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option1cimg` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option1ctext` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option1dimg` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option1dtext` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option1eimg` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option1etext` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option2aimg` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option2atext` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option2bimg` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option2btext` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option2cimg` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option2ctext` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option2dimg` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option2dtext` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option2eimg` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `option2etext` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `question_img1` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `question_img2` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `question_img3` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `question_text1` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `question_text2` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `question_text3` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `review` varchar(1000) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `test_test_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`question_id`) USING BTREE,
  INDEX `FKakgj0tvwvkim8c5fdhsfd1e3w`(`test_test_id`) USING BTREE,
  CONSTRAINT `FKakgj0tvwvkim8c5fdhsfd1e3w` FOREIGN KEY (`test_test_id`) REFERENCES `test` (`test_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 31 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of question
-- ----------------------------
INSERT INTO `question` VALUES (1, 0, '2025-08-01 19:32:04.090000', 0, '2025-08-01 19:32:04.090000', 0, NULL, 'Mouse', NULL, 'Disk Drive', NULL, 'Operating System', NULL, 'Solid State Driver', NULL, 'Random Access Memory', 3, 1, b'0', b'0', b'1', b'0', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Which of the following is NOT a “computer hardware”?', NULL, NULL, NULL, NULL, 1);
INSERT INTO `question` VALUES (2, 0, '2025-08-01 19:32:04.109000', 0, '2025-08-01 19:32:04.109000', 0, NULL, 'Kilobyte', NULL, 'Terabyte', NULL, 'Youbyte', NULL, 'Megabyte', NULL, 'Zettabyte', 3, 2, b'0', b'0', b'1', b'0', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Which of the following is NOT a unit of measurement for data?', NULL, NULL, NULL, NULL, 1);
INSERT INTO `question` VALUES (3, 0, '2025-08-01 19:32:04.121000', 0, '2025-08-01 19:32:04.121000', 0, NULL, 'devices, architecture, work', NULL, 'systems, purpose, functions', NULL, 'functions, objective, activity', NULL, 'software, functionality, targets', NULL, 'components, boundary, objectives', 5, 3, b'0', b'0', b'0', b'0', b'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'The following statement refers to a definition of an information system.', '“A system is a set of interrelated ________________, with a clearly defined ________________,working together to achieve a common set of ________________.”', 'Which of the following options correctly completes the blanks in the above statement?', NULL, NULL, 1);
INSERT INTO `question` VALUES (4, 0, '2025-08-01 19:32:04.138000', 0, '2025-08-01 19:32:04.138000', 0, NULL, 'users', NULL, 'hardware', NULL, 'data resources', NULL, 'marketing strategy', NULL, 'communications networks', 4, 4, b'0', b'0', b'0', b'1', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Which of the following is NOT a component of an information system?', NULL, NULL, NULL, NULL, 1);
INSERT INTO `question` VALUES (5, 0, '2025-08-01 19:32:04.147000', 0, '2025-08-01 19:32:04.147000', 0, NULL, 'A-I, B-II, C-III, D-IV', NULL, 'A-II, B-III, C-IV, D-I', NULL, 'A-III, B-IV, C-I, D-II', NULL, 'A-IV, B-I, C-II, D-III', NULL, 'A-III, B-II, C-I, D-IV', 5, 5, b'0', b'0', b'0', b'0', b'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '/images/question/6bc440a2-ed75-4d44-80c4-8291df32a80c_Screenshot 2025-07-25 161521.png', NULL, NULL, 'Consider the following list of four major areas of information system knowledge needed by business professionals and the list of descriptions.', 'Which of the following correctly matches the above listed areas with the descriptions?', NULL, NULL, NULL, 1);
INSERT INTO `question` VALUES (6, 0, '2025-08-01 19:32:04.160000', 0, '2025-08-01 19:32:04.160000', 0, NULL, 'Industry Rivalry', NULL, 'Threat of Substitutes', NULL, 'Threat of New Entrants', NULL, 'Bargaining Power of Buyers', NULL, 'Bargaining Power of Suppliers', 4, 6, b'0', b'0', b'0', b'1', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Consider the following scenario', '“By utilizing customer data and analytics, businesses can better understand customer preferences, adapt pricing strategies, and enhance product offerings. Information systems can help firms maintain a competitive edge by influencing customer purchasing decisions, reducing the power customers have in driving prices too low.”', 'Which of Porter’s Five Forces is being addressed in the above scenario?', NULL, NULL, 1);
INSERT INTO `question` VALUES (7, 0, '2025-08-01 19:32:04.170000', 0, '2025-08-01 19:32:04.170000', 0, NULL, 'Information systems provide tools to monitor market trends, making it easier for companies to switch between products and services in response to consumer demand.', NULL, 'Information systems allow firms to monitor customer behavior and adjust service offerings, making it easier for customers to switch to competitors by offering lower prices.', NULL, 'Information systems help companies set up exclusive contracts and pricing structures that incentivize customers to switch to competitors more frequently by offering short-term promotions.', NULL, 'By creating new business models supported by information systems, companies can introduce additional features that encourage customers to switch frequently between service providers.', NULL, 'Through technological investments, firms can create systems that make customers and suppliers highly reliant on their services, increasing the effort, time, and cost required for them to switch to other providers.', 5, 7, b'0', b'0', b'0', b'0', b'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Which of the following statements best describes how information systems can be used to increase switching costs and strengthen a company\'s competitive position?', NULL, NULL, NULL, NULL, 1);
INSERT INTO `question` VALUES (8, 0, '2025-08-01 19:32:04.179000', 0, '2025-08-01 19:32:04.179000', 0, NULL, 'add customer value', NULL, 'leverage investment', NULL, 'learn to survive', NULL, 'raise barriers to entry', NULL, 'adapt the changes', 2, 8, b'0', b'1', b'0', b'0', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Consider the following statement.', '“A company investing in advanced computer-based information systems to improve the efficiency of its own business processes can __________________________ in IT by developing new products and services that would not be possible without a strong IT capability.”', 'Which of the following is the most appropriate term to fill in the blank in the above statement?', NULL, NULL, 1);
INSERT INTO `question` VALUES (9, 0, '2025-08-01 19:32:04.189000', 0, '2025-08-01 19:32:04.189000', 0, NULL, 'Targeted Marketing System', NULL, 'Customer Relationship Management System', NULL, 'Automated Just-in-Time Warehousing System', NULL, 'Computer- Aided Flexible Manufacturing System', NULL, 'Online Point-of-Sale and Order Processing System', 3, 9, b'0', b'0', b'1', b'0', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'A firm in the garment industry is interested in introducing an information system to improve the performance of their inbound logistics. Which of the following systems would best meet this requirement?', NULL, NULL, NULL, NULL, 1);
INSERT INTO `question` VALUES (10, 0, '2025-08-01 19:32:04.198000', 0, '2025-08-01 19:32:04.198000', 0, NULL, 'Employee training programs to help staff utilize the IS effectively', NULL, 'A company’s existing IT infrastructure such as server to run the IS', NULL, 'A software application to manage inventory and track orders via the IS', NULL, 'An advanced database management system to store and retrieve data of the IS', NULL, 'The development of custom software code to implement a core function in the system', 1, 10, b'1', b'0', b'0', b'0', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Which of the following is an example of a complementary asset necessary for maximizing the value of an information system (IS) in an organization?', NULL, NULL, NULL, NULL, 1);
INSERT INTO `question` VALUES (11, 0, '2025-08-02 15:26:45.331000', 0, '2025-08-02 15:26:45.331000', 0, NULL, 'Mouse', NULL, 'Disk Drive', NULL, 'Operating System', NULL, 'Solid State Driver', NULL, 'Random Access Memory', 3, 1, b'0', b'0', b'1', b'0', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Which of the following is NOT a “computer hardware”?', NULL, NULL, NULL, NULL, 2);
INSERT INTO `question` VALUES (12, 0, '2025-08-02 15:26:45.363000', 0, '2025-08-02 15:26:45.363000', 0, NULL, 'Kilobyte', NULL, 'Terabyte', NULL, 'Youbyte', NULL, 'Megabyte', NULL, 'Zettabyte', 3, 2, b'0', b'0', b'1', b'0', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Which of the following is NOT a unit of measurement for data?', NULL, NULL, NULL, NULL, 2);
INSERT INTO `question` VALUES (13, 0, '2025-08-02 15:26:45.375000', 0, '2025-08-02 15:26:45.375000', 0, NULL, 'devices, architecture, work', NULL, 'systems, purpose, functions', NULL, 'functions, objective, activity', NULL, 'software, functionality, targets', NULL, 'components, boundary, objectives', 5, 3, b'0', b'0', b'0', b'0', b'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'The following statement refers to a definition of an information system.', '“A system is a set of interrelated ________________, with a clearly defined ________________,working together to achieve a common set of ________________.”', 'Which of the following options correctly completes the blanks in the above statement?', NULL, NULL, 2);
INSERT INTO `question` VALUES (14, 0, '2025-08-02 15:26:45.387000', 0, '2025-08-02 15:26:45.387000', 0, NULL, 'users', NULL, 'hardware', NULL, 'data resources', NULL, 'marketing strategy', NULL, 'communications networks', 4, 4, b'0', b'0', b'0', b'1', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Which of the following is NOT a component of an information system?', NULL, NULL, NULL, NULL, 2);
INSERT INTO `question` VALUES (15, 0, '2025-08-02 15:26:45.402000', 0, '2025-08-02 15:26:45.402000', 0, NULL, 'A-I, B-II, C-III, D-IV', NULL, 'A-II, B-III, C-IV, D-I', NULL, 'A-III, B-IV, C-I, D-II', NULL, 'A-IV, B-I, C-II, D-III', NULL, 'A-III, B-II, C-I, D-IV', 5, 5, b'0', b'0', b'0', b'0', b'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '/images/question/6bc440a2-ed75-4d44-80c4-8291df32a80c_Screenshot 2025-07-25 161521.png', NULL, NULL, 'Consider the following list of four major areas of information system knowledge needed by business professionals and the list of descriptions.', 'Which of the following correctly matches the above listed areas with the descriptions?', NULL, NULL, NULL, 2);
INSERT INTO `question` VALUES (16, 0, '2025-08-02 15:26:45.418000', 0, '2025-08-02 15:26:45.418000', 0, NULL, 'Industry Rivalry', NULL, 'Threat of Substitutes', NULL, 'Threat of New Entrants', NULL, 'Bargaining Power of Buyers', NULL, 'Bargaining Power of Suppliers', 4, 6, b'0', b'0', b'0', b'1', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Consider the following scenario', '“By utilizing customer data and analytics, businesses can better understand customer preferences, adapt pricing strategies, and enhance product offerings. Information systems can help firms maintain a competitive edge by influencing customer purchasing decisions, reducing the power customers have in driving prices too low.”', 'Which of Porter’s Five Forces is being addressed in the above scenario?', NULL, NULL, 2);
INSERT INTO `question` VALUES (17, 0, '2025-08-02 15:26:45.429000', 0, '2025-08-02 15:26:45.429000', 0, NULL, 'Information systems provide tools to monitor market trends, making it easier for companies to switch between products and services in response to consumer demand.', NULL, 'Information systems allow firms to monitor customer behavior and adjust service offerings, making it easier for customers to switch to competitors by offering lower prices.', NULL, 'Information systems help companies set up exclusive contracts and pricing structures that incentivize customers to switch to competitors more frequently by offering short-term promotions.', NULL, 'By creating new business models supported by information systems, companies can introduce additional features that encourage customers to switch frequently between service providers.', NULL, 'Through technological investments, firms can create systems that make customers and suppliers highly reliant on their services, increasing the effort, time, and cost required for them to switch to other providers.', 5, 7, b'0', b'0', b'0', b'0', b'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Which of the following statements best describes how information systems can be used to increase switching costs and strengthen a company\'s competitive position?', NULL, NULL, NULL, NULL, 2);
INSERT INTO `question` VALUES (18, 0, '2025-08-02 15:26:45.441000', 0, '2025-08-02 15:26:45.441000', 0, NULL, 'add customer value', NULL, 'leverage investment', NULL, 'learn to survive', NULL, 'raise barriers to entry', NULL, 'adapt the changes', 2, 8, b'0', b'1', b'0', b'0', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Consider the following statement.', '“A company investing in advanced computer-based information systems to improve the efficiency of its own business processes can __________________________ in IT by developing new products and services that would not be possible without a strong IT capability.”', 'Which of the following is the most appropriate term to fill in the blank in the above statement?', NULL, NULL, 2);
INSERT INTO `question` VALUES (19, 0, '2025-08-02 15:26:45.450000', 0, '2025-08-02 15:26:45.450000', 0, NULL, 'Targeted Marketing System', NULL, 'Customer Relationship Management System', NULL, 'Automated Just-in-Time Warehousing System', NULL, 'Computer- Aided Flexible Manufacturing System', NULL, 'Online Point-of-Sale and Order Processing System', 3, 9, b'0', b'0', b'1', b'0', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'A firm in the garment industry is interested in introducing an information system to improve the performance of their inbound logistics. Which of the following systems would best meet this requirement?', NULL, NULL, NULL, NULL, 2);
INSERT INTO `question` VALUES (20, 0, '2025-08-02 15:26:45.460000', 0, '2025-08-02 15:26:45.460000', 0, NULL, 'Employee training programs to help staff utilize the IS effectively', NULL, 'A company’s existing IT infrastructure such as server to run the IS', NULL, 'A software application to manage inventory and track orders via the IS', NULL, 'An advanced database management system to store and retrieve data of the IS', NULL, 'The development of custom software code to implement a core function in the system', 1, 10, b'1', b'0', b'0', b'0', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Which of the following is an example of a complementary asset necessary for maximizing the value of an information system (IS) in an organization?', NULL, NULL, NULL, NULL, 2);
INSERT INTO `question` VALUES (21, 0, '2025-08-03 14:11:29.954000', 0, '2025-08-03 14:11:29.954000', 0, NULL, 'Ctrl', NULL, 'Alt', NULL, 'Shift', NULL, 'Insert', NULL, 'Ctrl + Shift', 1, 1, b'1', b'0', b'0', b'0', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Which of the following keys must also be used to select multiple worksheets in LibreOffice Calc while clicking the individual sheet tabs?', NULL, NULL, NULL, NULL, 3);
INSERT INTO `question` VALUES (22, 0, '2025-08-03 14:11:29.964000', 0, '2025-08-03 14:11:29.964000', 0, NULL, '1', NULL, '2', NULL, '3', NULL, '4', NULL, '5', 2, 2, b'0', b'1', b'0', b'0', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'What is the minimum font size LibreOffice Writer supports?', NULL, NULL, NULL, NULL, 3);
INSERT INTO `question` VALUES (23, 0, '2025-08-03 14:11:29.970000', 0, '2025-08-03 14:11:29.970000', 0, NULL, '.doc', NULL, '.odw', NULL, '.ott', NULL, '.dot', NULL, '.odt', 5, 3, b'0', b'0', b'0', b'0', b'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'What is the default file extension of LibreOffice Writer?', NULL, NULL, NULL, NULL, 3);
INSERT INTO `question` VALUES (24, 0, '2025-08-03 14:11:29.976000', 0, '2025-08-03 14:11:29.976000', 0, NULL, 'Spreadsheet', NULL, 'JDBC', NULL, 'ODBC', NULL, 'Google contacts', NULL, 'Text', 4, 4, b'0', b'0', b'0', b'1', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Which of the following is not a valid address data source in LibreOffice Writer?', NULL, NULL, NULL, NULL, 3);
INSERT INTO `question` VALUES (25, 0, '2025-08-03 14:11:29.982000', 0, '2025-08-03 14:11:29.982000', 0, NULL, 'Tools', NULL, 'Format', NULL, 'File', NULL, 'Insert', NULL, 'Form', 1, 5, b'1', b'0', b'0', b'0', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'In which menu of LibreOffice Writer has the mail merge wizard?', NULL, NULL, NULL, NULL, 3);
INSERT INTO `question` VALUES (26, 0, '2025-08-03 14:11:29.991000', 0, '2025-08-03 14:11:29.991000', 0, NULL, 'Place in document, mail, document, new document', NULL, 'Place in document, new document', NULL, 'Internet, mail', NULL, 'Internet, mail, document, new document', NULL, 'Internet, mail, import, document', 4, 6, b'0', b'0', b'0', b'1', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Which of the following options appears when inserting a hyperlink in LibreOffice Writer?', NULL, NULL, NULL, NULL, 3);
INSERT INTO `question` VALUES (27, 0, '2025-08-03 14:11:29.995000', 0, '2025-08-03 14:11:29.995000', 0, NULL, 'File-> Properties', NULL, 'File-> Export as', NULL, 'Tools ->Protect Document', NULL, 'File-> Digital Signatures', NULL, 'File-> Save as...', 5, 7, b'0', b'0', b'0', b'0', b'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'In which menu of LibreOffice Writer provides the option to password protect a document?', NULL, NULL, NULL, NULL, 3);
INSERT INTO `question` VALUES (28, 0, '2025-08-03 14:11:30.001000', 0, '2025-08-03 14:11:30.001000', 0, NULL, 'Format', NULL, 'Edit', NULL, 'Style', NULL, 'Sheet', NULL, 'Design', 1, 8, b'1', b'0', b'0', b'0', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'In which menu is the merge cells command found in LibreOffice Calc?', NULL, NULL, NULL, NULL, 3);
INSERT INTO `question` VALUES (29, 0, '2025-08-03 14:11:30.009000', 0, '2025-08-03 14:11:30.009000', 0, NULL, 'Ctrl+Enter', NULL, 'Alt+Enter', NULL, 'Shift+Enter', NULL, 'Arrow down+Enter', NULL, 'Shift+N+Enter', 1, 9, b'1', b'0', b'0', b'0', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Which key combination can be used to insert a line break within a cell in LibreOffice Calc?', NULL, NULL, NULL, NULL, 3);
INSERT INTO `question` VALUES (30, 0, '2025-08-03 14:11:30.015000', 0, '2025-08-03 14:11:30.015000', 0, NULL, '.xls', NULL, '.xlsx', NULL, '.ods', NULL, '.odt', NULL, '.csv', 0, 10, b'1', b'1', b'1', b'0', b'0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Which of the following file formats supported by LibreOffice Calc allows to save a spreadsheet document preserving document formatting?', NULL, NULL, NULL, NULL, 3);

-- ----------------------------
-- Table structure for schedule
-- ----------------------------
DROP TABLE IF EXISTS `schedule`;
CREATE TABLE `schedule`  (
  `schedule_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `card_color` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `date` date NULL DEFAULT NULL,
  `ending_time` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `generation_id` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `starting_time` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `course_module_course_module_id` bigint(20) NULL DEFAULT NULL,
  `lecture_room_lecture_room_id` bigint(20) NULL DEFAULT NULL,
  `availability` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  PRIMARY KEY (`schedule_id`) USING BTREE,
  INDEX `FKl85685ihve8v98h18j4xpw1n6`(`course_module_course_module_id`) USING BTREE,
  INDEX `FKn65hejo959c543udgm9fci0c9`(`lecture_room_lecture_room_id`) USING BTREE,
  CONSTRAINT `FKl85685ihve8v98h18j4xpw1n6` FOREIGN KEY (`course_module_course_module_id`) REFERENCES `course_module` (`course_module_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FKn65hejo959c543udgm9fci0c9` FOREIGN KEY (`lecture_room_lecture_room_id`) REFERENCES `lecture_room` (`lecture_room_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 30 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of schedule
-- ----------------------------
INSERT INTO `schedule` VALUES (1, 0, '2025-08-01 10:34:05.196000', 0, '2025-08-01 10:34:05.196000', 0, 'bg-primary', '2025-08-01', '12:30:00', '3086b4dd-8bfa-43af-bddd-0f7120ffba4c', '11:30:00', 'A', 1, 1, 'FT');
INSERT INTO `schedule` VALUES (2, 0, '2025-08-03 01:31:08.860000', 0, '2025-08-03 01:31:08.860000', 0, 'bg-primary', '2025-08-03', '10:00:00', '02951d6e-9c34-4c84-b6eb-6b273104c274', '08:00:00', 'A', 1, 1, 'PT');
INSERT INTO `schedule` VALUES (5, 0, '2025-08-03 08:27:44.065000', 0, '2025-08-03 08:27:44.066000', 0, 'bg-info', '2025-08-01', '10:00:00', 'c6f8311f-932f-4195-8ea8-1d6f11a57682', '08:00:00', 'A', 1, 1, 'PT');
INSERT INTO `schedule` VALUES (24, 0, '2025-08-03 10:03:54.945000', 0, '2025-08-03 10:04:30.858000', 1, 'bg-info', '2025-08-12', '10:00:00', '6050c729-a8cc-404d-994c-2cb8f10e2c8b', '08:00:00', 'A', 2, 1, 'PT');
INSERT INTO `schedule` VALUES (25, 0, '2025-08-03 10:03:54.955000', 0, '2025-08-03 10:03:54.955000', 0, 'bg-info', '2025-08-17', '10:00:00', '6050c729-a8cc-404d-994c-2cb8f10e2c8b', '08:00:00', 'A', 2, 1, 'PT');
INSERT INTO `schedule` VALUES (26, 0, '2025-08-03 10:03:54.957000', 0, '2025-08-03 10:03:54.957000', 0, 'bg-info', '2025-08-24', '10:00:00', '6050c729-a8cc-404d-994c-2cb8f10e2c8b', '08:00:00', 'A', 2, 1, 'PT');
INSERT INTO `schedule` VALUES (27, 0, '2025-08-03 10:03:54.960000', 0, '2025-08-03 10:03:54.960000', 0, 'bg-info', '2025-08-31', '10:00:00', '6050c729-a8cc-404d-994c-2cb8f10e2c8b', '08:00:00', 'A', 2, 1, 'PT');
INSERT INTO `schedule` VALUES (28, 0, '2025-08-03 14:00:11.162000', 0, '2025-08-03 14:00:11.162000', 0, 'bg-success', '2025-08-03', '16:00:00', '1b32abea-24ff-41ed-86fd-5610ad15fe6c', '14:00:00', 'A', 1, 1, 'PT');
INSERT INTO `schedule` VALUES (29, 0, '2025-08-03 14:01:07.450000', 0, '2025-08-03 14:01:30.970000', 1, 'bg-warning', '2025-08-03', '15:00:00', '11cc7261-b13f-4411-b40a-8e6820519af1', '13:00:00', 'A', 2, 3, 'FT');

-- ----------------------------
-- Table structure for semester
-- ----------------------------
DROP TABLE IF EXISTS `semester`;
CREATE TABLE `semester`  (
  `semester_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `semester_name` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `semester_no` int(11) NOT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `course_course_id` bigint(20) NULL DEFAULT NULL,
  `short_name` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  PRIMARY KEY (`semester_id`) USING BTREE,
  INDEX `FK67pjf2tgjyfeoyx1wpmersyns`(`course_course_id`) USING BTREE,
  CONSTRAINT `FK67pjf2tgjyfeoyx1wpmersyns` FOREIGN KEY (`course_course_id`) REFERENCES `course` (`course_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of semester
-- ----------------------------
INSERT INTO `semester` VALUES (1, 0, '2025-07-31 23:26:45.933000', 0, '2025-07-31 23:26:45.933000', 0, 'Semester 1', 1, 'A', 1, 'Sem 1');
INSERT INTO `semester` VALUES (2, 0, '2025-07-31 23:26:45.946000', 0, '2025-07-31 23:26:45.946000', 0, 'Semester 2', 2, 'A', 1, 'Sem 2');
INSERT INTO `semester` VALUES (3, 0, '2025-07-31 23:26:45.953000', 0, '2025-07-31 23:26:45.953000', 0, 'Semester 3', 3, 'A', 1, 'Sem 3');
INSERT INTO `semester` VALUES (4, 0, '2025-07-31 23:26:45.975000', 0, '2025-07-31 23:26:45.975000', 0, 'Semester 4', 4, 'A', 1, 'Sem 4');
INSERT INTO `semester` VALUES (5, 0, '2025-07-31 23:26:45.981000', 0, '2025-07-31 23:26:45.981000', 0, 'Semester 5', 5, 'A', 1, 'Sem 5');
INSERT INTO `semester` VALUES (6, 0, '2025-07-31 23:26:45.986000', 0, '2025-07-31 23:26:45.986000', 0, 'Semester 6', 6, 'A', 1, 'Sem 6');

-- ----------------------------
-- Table structure for student
-- ----------------------------
DROP TABLE IF EXISTS `student`;
CREATE TABLE `student`  (
  `student_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `address` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `dob` date NULL DEFAULT NULL,
  `email` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `first_name` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `guardian_mobile_no` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `guardian_name` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `image` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `initials` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `joined_date` date NULL DEFAULT NULL,
  `last_name` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `mobile_no` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `nfc_id` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `nic` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `password` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `registration_no` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `reset_password` bit(1) NOT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `city_geo_area_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`student_id`) USING BTREE,
  INDEX `FKboegis8vxplhk8toeg9htnqrq`(`city_geo_area_id`) USING BTREE,
  CONSTRAINT `FKboegis8vxplhk8toeg9htnqrq` FOREIGN KEY (`city_geo_area_id`) REFERENCES `geo_area` (`geo_area_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 16 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of student
-- ----------------------------
INSERT INTO `student` VALUES (1, 1, '2025-07-03 22:07:52.844000', 1, '2025-08-02 17:31:13.416000', 1, NULL, '1999-04-28', 'arshadadahan133@gmail.com', 'Arshad', '0767899222', NULL, '/images/student/952a4023-966c-4aa7-8e53-0cd9cf2e3056_avatar-1.png', NULL, '2025-07-03', 'Adahan', '0767899222', '0132931299', '991190880V', 'GE6kpBrYTqqzksoaaSNUmA==', '2507030001', b'0', 'A', NULL);
INSERT INTO `student` VALUES (5, 1, '2025-08-02 14:27:28.932000', 5, '2025-08-02 19:13:44.196000', 3, NULL, '2001-05-13', 'afran@gmail.com', 'Afran', '0745454515', NULL, '/images/student/8a9f3bc3-1a33-41a6-84be-7f6d8b29fbca_image_cropper_1754142219056.jpg', NULL, '2025-08-02', 'Adahan', '0745454554', '0132926579', '', 'RMiDEH11sSc0AcYeqFpBMQ==', '2508020001', b'0', 'A', NULL);
INSERT INTO `student` VALUES (6, 1, '2025-08-03 11:28:59.339000', 0, '2025-08-03 11:28:59.339000', 0, '114, Park Avenue, Colombo', '1998-06-21', 'chandeepa.abhisheka@gmail.com', 'Chandeepa ', '0774333432', 'Rohini Rathnayake', NULL, 'ARP', '2025-08-03', 'Abhisheka', '0726894159', '1111111111', '981734621V', 'jmzEZAXZSHWwQIqXFkS3rne+kA6802Bd', '2508030001', b'1', 'A', 36);
INSERT INTO `student` VALUES (7, 1, '2025-08-03 11:31:34.719000', 0, '2025-08-03 11:31:34.719000', 0, '47, Main Street, Kurunegala', '1995-11-02', 'nishani.jayathilaka@yahoo.com', 'Nishani ', '0753624634', 'Lal Karunaratne', NULL, 'N.Jayathilaka', '2025-08-03', 'Jayathilaka', '0781821137', '2222222222', '956736260V', 'Sd8gHoyaGSDIHVVkxxwgf2biaXlQmnBP', '2508030002', b'1', 'A', 1220);
INSERT INTO `student` VALUES (8, 1, '2025-08-03 11:33:30.411000', 0, '2025-08-03 11:33:30.411000', 0, '50, Lake Road, Negombo', '2001-09-11', 'pasindu.ranathunga@outlook.com', 'Pasindu ', '0776617810', 'Pushpa Senanayake', NULL, 'P.Ranathunga', '2025-08-03', 'Ranathunga', '0793711181', '3333333333', '200125582811', 'mwBJk/Z/8/uS9sYAMJQUtCRs58y9EDHi', '2508030003', b'1', 'A', 1335);
INSERT INTO `student` VALUES (9, 1, '2025-08-03 11:35:38.022000', 0, '2025-08-03 11:35:38.022000', 0, ' 212, Hill Street, Colombo', '2002-03-12', 'ishara.madushani@gmail.com', 'Ishara ', '0788562203', 'Bimali Perera', NULL, 'I.Madushani', '2025-08-03', 'Madushani', '0756423803', '4444444444', '200280399932', 'omEvM9lhbE5UmnPO5BmGHg5hlPt5gZpb', '2508030004', b'1', 'A', 36);
INSERT INTO `student` VALUES (10, 1, '2025-08-03 11:38:50.053000', 0, '2025-08-03 11:38:50.053000', 0, '72, Park Avenue, Badulla', '2001-10-20', 'isharaaa.madushani@gmail.com', 'Kavindu ', '0749196141', 'Rathna Rathnayake', NULL, 'K.Lakmal', '2025-08-03', 'Lakmal', '0786368207', '5555555555', '200129492732', 'FN6JjuBRqN0IH3B+q/yV/E1iqBfGAPKy', '2508030005', b'1', 'A', 111);
INSERT INTO `student` VALUES (11, 1, '2025-08-03 11:40:20.944000', 0, '2025-08-03 11:40:20.944000', 0, '133, Hill Street, Kandy', '1999-07-24', 'nimasha.perera@yahoo.com', 'Nimasha ', '0799838316', 'Manjula Senanayake', NULL, 'N.Perera', '2025-08-03', 'Perera', '0764559750', '6666666666', '995725177V', 'Cl8SQJ3P72k9aKaiKwDup3xU+pcmY8Zw', '2508030006', b'1', 'A', 618);
INSERT INTO `student` VALUES (12, 1, '2025-08-03 11:42:04.723000', 0, '2025-08-03 11:42:04.723000', 0, '75, Main Street, Galle', '2002-12-13', 'nimesha.dilrukshi@outlook.com', 'Nimesha ', '0729092506', 'Manjula Perera', NULL, 'N.Dilrukshi', '2025-08-03', 'Dilrukshi', '0719877315', '7777777777', '200271356898', '0lU4k0tWuRom1Kc+3MTTbD/S3IGjAo1P', '2508030007', b'1', 'A', 792);
INSERT INTO `student` VALUES (13, 1, '2025-08-03 11:43:47.572000', 0, '2025-08-03 11:43:47.572000', 0, '148, Lake Road, Kurunegala', '2000-12-06', 'tharindu.bandara@gmail.com', 'Tharindu ', '0793206606', 'Kumari Ekanayake', NULL, 'T.Bandara', '2025-08-03', 'Bandara', '0756030304', '8888888888', '200070692546', 'dZHQAPIFROTiATXhOxanRadJQNpe2Ovz', '2508030008', b'1', 'A', 105);
INSERT INTO `student` VALUES (14, 1, '2025-08-03 11:45:18.688000', 0, '2025-08-03 11:45:18.688000', 0, '10, Main Street, Anuradhapura', '1998-07-04', 'sanduni.rathnayake@yahoo.com', 'Sanduni ', '0771467699', 'Sarath Bandara', NULL, 'S.Rathnayake', '2025-08-03', 'Rathnayake', '0744489668', '9999999999', '985512708V', '03Zxr+HP3g4VjX4bwfc94AUNREqnRJFS', '2508030009', b'1', 'A', 614);
INSERT INTO `student` VALUES (15, 1, '2025-08-03 13:56:02.494000', 15, '2025-08-03 14:07:47.360000', 1, NULL, '2000-02-26', 'shakeer@gmail.com', 'Shakeer', '0743422323', 'Sharaz', '/images/student/3143fa93-7d5e-40f0-93c2-0ceb7bac1c13_student-img1.png', NULL, '2025-08-03', 'Ahamed', '0714774554', '0132073523', '200042343212', 'D+7Rery3IQMOZHzK9vh+TqPYexT5s+t6', '2508030010', b'0', 'A', NULL);

-- ----------------------------
-- Table structure for student_attendance
-- ----------------------------
DROP TABLE IF EXISTS `student_attendance`;
CREATE TABLE `student_attendance`  (
  `student_attendance_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `schedule_schedule_id` bigint(20) NULL DEFAULT NULL,
  `student_student_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`student_attendance_id`) USING BTREE,
  INDEX `FK2xtc78p8l1qusrrkgrakw8gkc`(`schedule_schedule_id`) USING BTREE,
  INDEX `FK8nd18m7rvrethedofr7t2q8yr`(`student_student_id`) USING BTREE,
  CONSTRAINT `FK2xtc78p8l1qusrrkgrakw8gkc` FOREIGN KEY (`schedule_schedule_id`) REFERENCES `schedule` (`schedule_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FK8nd18m7rvrethedofr7t2q8yr` FOREIGN KEY (`student_student_id`) REFERENCES `student` (`student_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of student_attendance
-- ----------------------------
INSERT INTO `student_attendance` VALUES (1, 0, '2025-08-03 01:34:05.656000', 0, '2025-08-03 01:34:05.656000', 0, 2, 1);
INSERT INTO `student_attendance` VALUES (2, 0, '2025-08-03 01:59:04.631000', 0, '2025-08-03 01:59:04.631000', 0, 2, 5);
INSERT INTO `student_attendance` VALUES (3, 0, '2025-08-03 14:02:38.813000', 0, '2025-08-03 14:02:38.813000', 0, 28, 15);
INSERT INTO `student_attendance` VALUES (4, 0, '2025-08-03 14:04:53.308000', 0, '2025-08-03 14:04:53.308000', 0, 28, 1);

-- ----------------------------
-- Table structure for student_enrollment
-- ----------------------------
DROP TABLE IF EXISTS `student_enrollment`;
CREATE TABLE `student_enrollment`  (
  `student_enrolment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `availability` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `joined_date` date NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `year` int(11) NOT NULL,
  `semester_semester_id` bigint(20) NULL DEFAULT NULL,
  `student_student_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`student_enrolment_id`) USING BTREE,
  INDEX `FKpato1qbofjuwsmtlsccdnk0uq`(`semester_semester_id`) USING BTREE,
  INDEX `FKm9eojjcr7xcb4inprd0vn7101`(`student_student_id`) USING BTREE,
  CONSTRAINT `FKm9eojjcr7xcb4inprd0vn7101` FOREIGN KEY (`student_student_id`) REFERENCES `student` (`student_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FKpato1qbofjuwsmtlsccdnk0uq` FOREIGN KEY (`semester_semester_id`) REFERENCES `semester` (`semester_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 8 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of student_enrollment
-- ----------------------------
INSERT INTO `student_enrollment` VALUES (1, 0, '2025-08-01 15:38:36.063000', 0, '2025-08-01 15:38:36.063000', 0, 'PT', '2025-08-01', 'A', 2025, 1, 1);
INSERT INTO `student_enrollment` VALUES (2, 0, '2025-08-03 07:02:58.199000', 0, '2025-08-03 07:02:58.199000', 0, 'PT', '2025-08-03', 'A', 2025, 1, 5);
INSERT INTO `student_enrollment` VALUES (3, 0, '2025-08-03 13:57:47.107000', 0, '2025-08-03 13:57:47.107000', 0, 'PT', '2025-08-03', 'A', 2025, 1, 15);
INSERT INTO `student_enrollment` VALUES (4, 0, '2025-08-03 15:03:48.703000', 0, '2025-08-03 15:03:48.703000', 0, 'PT', '2025-08-03', 'A', 2025, 1, 6);
INSERT INTO `student_enrollment` VALUES (5, 0, '2025-08-03 15:06:03.012000', 0, '2025-08-03 15:06:03.012000', 0, 'PT', '2025-08-03', 'A', 2026, 2, 6);
INSERT INTO `student_enrollment` VALUES (6, 0, '2025-08-03 15:07:53.817000', 0, '2025-08-03 15:07:53.817000', 0, 'PT', '2025-08-03', 'A', 2026, 2, 7);
INSERT INTO `student_enrollment` VALUES (7, 0, '2025-08-03 15:09:29.600000', 0, '2025-08-03 15:09:29.600000', 0, 'PT', '2025-08-03', 'A', 2026, 2, 8);

-- ----------------------------
-- Table structure for student_payment_structure
-- ----------------------------
DROP TABLE IF EXISTS `student_payment_structure`;
CREATE TABLE `student_payment_structure`  (
  `student_payment_structure_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `discount_amount` double NOT NULL,
  `discount_rate` double NOT NULL,
  `payment_structure_payment_structure_id` bigint(20) NULL DEFAULT NULL,
  `student_student_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`student_payment_structure_id`) USING BTREE,
  INDEX `FK8auy41iqwjfn7uw9sac602m8w`(`payment_structure_payment_structure_id`) USING BTREE,
  INDEX `FK8whml4v5a5o63ep945e9ev1x2`(`student_student_id`) USING BTREE,
  CONSTRAINT `FK8auy41iqwjfn7uw9sac602m8w` FOREIGN KEY (`payment_structure_payment_structure_id`) REFERENCES `payment_structure` (`payment_structure_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FK8whml4v5a5o63ep945e9ev1x2` FOREIGN KEY (`student_student_id`) REFERENCES `student` (`student_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 10 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of student_payment_structure
-- ----------------------------
INSERT INTO `student_payment_structure` VALUES (1, 0, '2025-08-01 15:38:36.302000', 0, '2025-08-01 15:38:36.302000', 0, 0, 0, 1, 1);
INSERT INTO `student_payment_structure` VALUES (2, 0, '2025-08-01 15:38:36.330000', 0, '2025-08-01 15:38:36.330000', 0, 0, 0, 3, 1);
INSERT INTO `student_payment_structure` VALUES (3, 0, '2025-08-03 07:02:58.345000', 0, '2025-08-03 07:02:58.345000', 0, 0, 0, 2, 5);
INSERT INTO `student_payment_structure` VALUES (4, 0, '2025-08-03 13:57:47.115000', 0, '2025-08-03 13:57:47.115000', 0, 0, 0, 2, 15);
INSERT INTO `student_payment_structure` VALUES (5, 0, '2025-08-03 15:03:48.929000', 0, '2025-08-03 15:03:48.929000', 0, 5000, 0, 1, 6);
INSERT INTO `student_payment_structure` VALUES (6, 0, '2025-08-03 15:03:48.974000', 0, '2025-08-03 15:03:48.974000', 0, 5000, 0, 3, 6);
INSERT INTO `student_payment_structure` VALUES (7, 0, '2025-08-03 15:06:03.017000', 0, '2025-08-03 15:06:03.017000', 0, 5000, 0, 6, 6);
INSERT INTO `student_payment_structure` VALUES (8, 0, '2025-08-03 15:07:53.823000', 0, '2025-08-03 15:07:53.823000', 0, 5000, 0, 6, 7);
INSERT INTO `student_payment_structure` VALUES (9, 0, '2025-08-03 15:09:29.607000', 0, '2025-08-03 15:09:29.607000', 0, 10000, 0, 6, 8);

-- ----------------------------
-- Table structure for system_menu
-- ----------------------------
DROP TABLE IF EXISTS `system_menu`;
CREATE TABLE `system_menu`  (
  `menu_item_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `icon_class` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `menu_item` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `parent_id` bigint(20) NOT NULL,
  `path_url` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `sequence` int(11) NOT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  PRIMARY KEY (`menu_item_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 30 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of system_menu
-- ----------------------------
INSERT INTO `system_menu` VALUES (1, 0, '2025-05-05 13:58:26.769000', 0, '2025-07-31 13:27:57.859000', 2, 'fa-solid fa-users text-danger', 'Student', 0, '/', 1, 'A');
INSERT INTO `system_menu` VALUES (2, 0, '2025-05-05 14:21:21.316000', 0, '2025-05-05 14:21:21.316000', 0, 'fa fa-dot', 'Student', 1, '/student/student', 1, 'A');
INSERT INTO `system_menu` VALUES (4, 0, '2025-05-05 14:23:53.027000', 0, '2025-07-31 13:25:09.426000', 2, 'fa-solid fa-server text-warning', 'Reference', 0, '/', 2, 'A');
INSERT INTO `system_menu` VALUES (5, 0, '2025-05-05 14:24:28.406000', 0, '2025-05-05 14:24:28.406000', 0, 'fa fa-dot', 'System Menu', 4, '/reference/system-menu', 1, 'A');
INSERT INTO `system_menu` VALUES (6, 0, '2025-05-05 14:38:22.571000', 0, '2025-05-05 14:38:22.571000', 0, 'fa fa-dot', 'Access Group', 4, '/reference/access-group', 2, 'A');
INSERT INTO `system_menu` VALUES (7, 0, '2025-05-05 14:39:26.144000', 0, '2025-05-05 14:39:26.144000', 0, 'fa fa-dot', 'Group Privilege', 4, '/reference/group-privilege', 3, 'A');
INSERT INTO `system_menu` VALUES (8, 0, '2025-05-05 14:41:16.004000', 0, '2025-05-05 14:41:16.004000', 0, 'fa fa-dot', 'Officer', 4, '/reference/officer', 4, 'A');
INSERT INTO `system_menu` VALUES (9, 0, '2025-05-05 14:41:50.924000', 0, '2025-05-05 14:41:50.924000', 0, 'fa fa-dot', 'Lecturer', 4, '/reference/lecturer', 5, 'A');
INSERT INTO `system_menu` VALUES (10, 0, '2025-05-05 14:45:13.576000', 0, '2025-05-05 21:07:46.951000', 1, 'fa fa-dot', 'Test', 1, '/student/student-test', 2, 'A');
INSERT INTO `system_menu` VALUES (11, 0, '2025-05-05 14:48:08.369000', 0, '2025-07-31 13:38:24.886000', 1, 'fa-solid fa-book text-info', 'Course', 0, '/', 3, 'A');
INSERT INTO `system_menu` VALUES (12, 0, '2025-05-05 20:57:21.214000', 0, '2025-05-05 20:57:21.214000', 0, 'fa fa-dot', 'Course', 11, '/course/course', 1, 'A');
INSERT INTO `system_menu` VALUES (13, 0, '2025-05-05 20:58:03.011000', 0, '2025-05-05 20:58:03.011000', 0, 'fa fa-dot', 'Batch', 11, '/course/batch', 2, 'A');
INSERT INTO `system_menu` VALUES (14, 0, '2025-05-05 20:58:42.222000', 0, '2025-05-05 20:58:42.222000', 0, 'fa fa-dot', 'Course Module', 11, '/course/course-module', 3, 'A');
INSERT INTO `system_menu` VALUES (15, 0, '2025-05-05 20:59:40.179000', 0, '2025-05-05 20:59:40.179000', 0, 'fa fa-dot', 'Schedule', 11, '/course/schedule', 4, 'A');
INSERT INTO `system_menu` VALUES (16, 0, '2025-05-05 21:01:18.469000', 0, '2025-07-31 14:03:08.813000', 2, 'fa-solid fa-money-bills text-danger', 'Payment', 0, '/', 4, 'A');
INSERT INTO `system_menu` VALUES (17, 0, '2025-05-05 21:02:12.330000', 0, '2025-05-05 21:02:12.330000', 0, 'fa fa-dot', 'Payment Structure', 16, '/payment/payment-structure', 1, 'A');
INSERT INTO `system_menu` VALUES (18, 0, '2025-05-05 21:03:07.809000', 0, '2025-05-05 21:03:07.809000', 0, 'fa fa-dot', 'Payment Collection', 16, '/payment/payment-collection', 2, 'A');
INSERT INTO `system_menu` VALUES (19, 0, '2025-05-05 21:03:54.066000', 0, '2025-05-05 21:09:19.305000', 1, 'fa fa-dot', 'Student Payments', 16, '/payment/student-payment', 3, 'A');
INSERT INTO `system_menu` VALUES (20, 0, '2025-05-05 21:05:03.849000', 0, '2025-07-31 13:59:02.974000', 2, 'fa-solid fa-clipboard-check text-primary', 'Attendance', 0, '/', 5, 'A');
INSERT INTO `system_menu` VALUES (21, 0, '2025-05-05 21:05:53.977000', 0, '2025-05-05 21:11:17.519000', 1, 'fa fa-dot', 'Student Attendance', 20, '/attendance/student-attendance', 1, 'A');
INSERT INTO `system_menu` VALUES (22, 0, '2025-06-17 19:41:07.207000', 0, '2025-07-31 14:00:49.511000', 2, 'fa fa-file-invoice text-success', 'Reports', 0, '/', 6, 'A');
INSERT INTO `system_menu` VALUES (23, 0, '2025-06-17 19:42:06.958000', 0, '2025-07-29 19:08:03.011000', 2, 'fa fa-dot', 'Student Attendance', 22, '/report/student-attendance-report', 1, 'A');
INSERT INTO `system_menu` VALUES (24, 0, '2025-06-20 19:54:11.241000', 0, '2025-06-20 19:54:11.241000', 0, 'fa fa-dot', 'Lecture Room', 4, '/reference/lecture-room', 6, 'A');
INSERT INTO `system_menu` VALUES (25, 0, '2025-06-28 20:30:28.817000', 0, '2025-06-28 20:30:28.818000', 0, 'fa fa-dot', 'Student Performance Report', 22, '/report/student-performance-report', 2, 'A');
INSERT INTO `system_menu` VALUES (26, 0, '2025-07-12 21:48:38.443000', 0, '2025-07-12 21:48:38.443000', 0, 'fa fa-dot', 'Teaching Assignment', 11, '/course/lecturer-assignment', 5, 'A');
INSERT INTO `system_menu` VALUES (27, 0, '2025-07-29 19:33:00.338000', 0, '2025-07-29 19:33:00.338000', 0, 'fa fa-dot', 'Student Payment Collection Report', 22, '/report/student-payment-report', 3, 'A');
INSERT INTO `system_menu` VALUES (28, 0, '2025-08-01 11:57:30.016000', 0, '2025-08-01 11:57:30.016000', 0, 'fa fa-dot', 'Student Enrolment', 1, '/student/student-enrolment', 3, 'A');
INSERT INTO `system_menu` VALUES (29, 0, '2025-08-03 01:17:34.081000', 0, '2025-08-03 01:17:34.081000', 0, 'fa fa-dot', 'Lecturer Rating Report', 22, '/report/lecturer-rating-report', 4, 'A');

-- ----------------------------
-- Table structure for teaching_assignment
-- ----------------------------
DROP TABLE IF EXISTS `teaching_assignment`;
CREATE TABLE `teaching_assignment`  (
  `teaching_assignment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `assigned_on` date NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `course_course_id` bigint(20) NULL DEFAULT NULL,
  `course_module_course_module_id` bigint(20) NULL DEFAULT NULL,
  `lecturer_lecturer_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`teaching_assignment_id`) USING BTREE,
  INDEX `FK1xjicx647p4gafijnxxitg85n`(`course_course_id`) USING BTREE,
  INDEX `FK1c5o5olsy4j2tbjgk1yx6syjh`(`course_module_course_module_id`) USING BTREE,
  INDEX `FK7qctcqv1tfpu9p3tgdswuuo8p`(`lecturer_lecturer_id`) USING BTREE,
  CONSTRAINT `FK1c5o5olsy4j2tbjgk1yx6syjh` FOREIGN KEY (`course_module_course_module_id`) REFERENCES `course_module` (`course_module_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FK1xjicx647p4gafijnxxitg85n` FOREIGN KEY (`course_course_id`) REFERENCES `course` (`course_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FK7qctcqv1tfpu9p3tgdswuuo8p` FOREIGN KEY (`lecturer_lecturer_id`) REFERENCES `lecturer` (`lecturer_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of teaching_assignment
-- ----------------------------

-- ----------------------------
-- Table structure for test
-- ----------------------------
DROP TABLE IF EXISTS `test`;
CREATE TABLE `test`  (
  `test_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `date` date NULL DEFAULT NULL,
  `no_of_questions` int(11) NOT NULL,
  `status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `test_name` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `time_from` time(6) NULL DEFAULT NULL,
  `time_mins_allocated` int(11) NOT NULL,
  `time_to` time(6) NULL DEFAULT NULL,
  `course_module_course_module_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`test_id`) USING BTREE,
  INDEX `FKd89e1uvg7thf7sl7fsb19tn6c`(`course_module_course_module_id`) USING BTREE,
  CONSTRAINT `FKd89e1uvg7thf7sl7fsb19tn6c` FOREIGN KEY (`course_module_course_module_id`) REFERENCES `course_module` (`course_module_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of test
-- ----------------------------
INSERT INTO `test` VALUES (1, 1, '2025-08-01 19:32:03.963000', 0, '2025-08-01 19:32:18.771000', 1, '2025-08-01', 10, 'A', 'IS Test 1', '19:00:00.000000', 30, '21:00:00.000000', 1);
INSERT INTO `test` VALUES (2, 1, '2025-08-02 15:26:45.151000', 1, '2025-08-02 15:38:53.571000', 2, '2025-08-02', 10, 'I', 'Test 2', '17:00:00.000000', 20, '18:00:00.000000', 1);
INSERT INTO `test` VALUES (3, 2, '2025-08-03 14:11:29.935000', 2, '2025-08-03 14:13:02.350000', 3, '2025-08-03', 10, 'A', 'Test 1', '14:00:00.000000', 20, '16:00:00.000000', 6);

-- ----------------------------
-- Table structure for test_attempt_marked_answer
-- ----------------------------
DROP TABLE IF EXISTS `test_attempt_marked_answer`;
CREATE TABLE `test_attempt_marked_answer`  (
  `test_attempt_answer_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) NOT NULL,
  `created_date` datetime(6) NULL DEFAULT NULL,
  `updated_by` bigint(20) NOT NULL,
  `updated_date` datetime(6) NULL DEFAULT NULL,
  `version_id` int(11) NOT NULL,
  `answer1marked` bit(1) NOT NULL,
  `answer2marked` bit(1) NOT NULL,
  `answer3marked` bit(1) NOT NULL,
  `answer4marked` bit(1) NOT NULL,
  `answer5marked` bit(1) NOT NULL,
  `answer_no` int(11) NOT NULL,
  `attempt_id` bigint(20) NOT NULL,
  `correct` bit(1) NOT NULL,
  `mark` double NOT NULL,
  `question_id` bigint(20) NOT NULL,
  `question_no` int(11) NOT NULL,
  PRIMARY KEY (`test_attempt_answer_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 21 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of test_attempt_marked_answer
-- ----------------------------
INSERT INTO `test_attempt_marked_answer` VALUES (1, 1, '2025-08-01 23:49:50.824000', 0, '2025-08-01 23:49:50.824000', 0, b'0', b'0', b'0', b'0', b'1', 0, 2, b'0', 0, 1, 1);
INSERT INTO `test_attempt_marked_answer` VALUES (2, 1, '2025-08-01 23:49:50.864000', 0, '2025-08-01 23:49:50.864000', 0, b'1', b'0', b'1', b'0', b'0', 0, 2, b'0', 0.75, 2, 2);
INSERT INTO `test_attempt_marked_answer` VALUES (3, 1, '2025-08-01 23:49:50.889000', 0, '2025-08-01 23:49:50.889000', 0, b'0', b'0', b'1', b'0', b'0', 0, 2, b'0', 0, 3, 3);
INSERT INTO `test_attempt_marked_answer` VALUES (4, 1, '2025-08-01 23:49:50.906000', 0, '2025-08-01 23:49:50.906000', 0, b'0', b'1', b'0', b'0', b'0', 0, 2, b'0', 0, 4, 4);
INSERT INTO `test_attempt_marked_answer` VALUES (5, 1, '2025-08-01 23:49:50.922000', 0, '2025-08-01 23:49:50.922000', 0, b'1', b'0', b'0', b'0', b'0', 0, 2, b'0', 0, 5, 5);
INSERT INTO `test_attempt_marked_answer` VALUES (6, 1, '2025-08-01 23:49:50.938000', 0, '2025-08-01 23:49:50.938000', 0, b'1', b'1', b'0', b'0', b'0', 0, 2, b'0', 0, 6, 6);
INSERT INTO `test_attempt_marked_answer` VALUES (7, 1, '2025-08-01 23:49:50.953000', 0, '2025-08-01 23:49:50.953000', 0, b'0', b'0', b'0', b'0', b'1', 0, 2, b'0', 1, 7, 7);
INSERT INTO `test_attempt_marked_answer` VALUES (8, 1, '2025-08-01 23:49:50.970000', 0, '2025-08-01 23:49:50.971000', 0, b'0', b'0', b'0', b'0', b'1', 0, 2, b'0', 0, 8, 8);
INSERT INTO `test_attempt_marked_answer` VALUES (9, 1, '2025-08-01 23:49:50.986000', 0, '2025-08-01 23:49:50.986000', 0, b'1', b'0', b'0', b'0', b'1', 0, 2, b'0', 0, 9, 9);
INSERT INTO `test_attempt_marked_answer` VALUES (10, 1, '2025-08-01 23:49:51.000000', 0, '2025-08-01 23:49:51.000000', 0, b'1', b'1', b'0', b'0', b'0', 0, 2, b'0', 0.75, 10, 10);
INSERT INTO `test_attempt_marked_answer` VALUES (11, 15, '2025-08-03 14:13:51.994000', 0, '2025-08-03 14:13:51.994000', 0, b'0', b'1', b'0', b'1', b'0', 0, 3, b'0', 0.75, 26, 1);
INSERT INTO `test_attempt_marked_answer` VALUES (12, 15, '2025-08-03 14:13:52.001000', 0, '2025-08-03 14:13:52.001000', 0, b'0', b'1', b'1', b'0', b'0', 0, 3, b'0', 0, 21, 2);
INSERT INTO `test_attempt_marked_answer` VALUES (13, 15, '2025-08-03 14:13:52.010000', 0, '2025-08-03 14:13:52.010000', 0, b'1', b'0', b'0', b'0', b'0', 0, 3, b'0', 0, 22, 3);
INSERT INTO `test_attempt_marked_answer` VALUES (14, 15, '2025-08-03 14:13:52.017000', 0, '2025-08-03 14:13:52.017000', 0, b'1', b'0', b'0', b'0', b'0', 0, 3, b'0', 0, 27, 4);
INSERT INTO `test_attempt_marked_answer` VALUES (15, 15, '2025-08-03 14:13:52.027000', 0, '2025-08-03 14:13:52.027000', 0, b'0', b'0', b'1', b'1', b'0', 0, 3, b'0', 0, 23, 5);
INSERT INTO `test_attempt_marked_answer` VALUES (16, 15, '2025-08-03 14:13:52.036000', 0, '2025-08-03 14:13:52.036000', 0, b'0', b'0', b'1', b'0', b'1', 0, 3, b'0', 0, 30, 6);
INSERT INTO `test_attempt_marked_answer` VALUES (17, 15, '2025-08-03 14:13:52.044000', 0, '2025-08-03 14:13:52.044000', 0, b'1', b'0', b'1', b'0', b'0', 0, 3, b'0', 0.75, 25, 7);
INSERT INTO `test_attempt_marked_answer` VALUES (18, 15, '2025-08-03 14:13:52.054000', 0, '2025-08-03 14:13:52.054000', 0, b'0', b'0', b'0', b'1', b'0', 0, 3, b'0', 0, 28, 8);
INSERT INTO `test_attempt_marked_answer` VALUES (19, 15, '2025-08-03 14:13:52.061000', 0, '2025-08-03 14:13:52.061000', 0, b'0', b'0', b'0', b'0', b'1', 0, 3, b'0', 0, 24, 9);
INSERT INTO `test_attempt_marked_answer` VALUES (20, 15, '2025-08-03 14:13:52.069000', 0, '2025-08-03 14:13:52.069000', 0, b'0', b'0', b'0', b'0', b'1', 0, 3, b'0', 0, 29, 10);

SET FOREIGN_KEY_CHECKS = 1;
